/*
 * Decompiled with CFR 0.152.
 */
package net.sf.derquinse.lucis;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.derquinse.lucis.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Page<T>
extends Result
implements Iterable<T> {
    private static final long serialVersionUID = -2166985025861839904L;
    private static final Page<Object> EMPTY = new Page(0, 0.0f, 0L, 0, Collections.emptyList());
    private final int firstResult;
    private final List<T> items;

    public static <T> Page<T> empty() {
        return EMPTY;
    }

    public Page(int totalHits, float maxScore, long time, int firstResult, List<T> items) {
        super(totalHits, maxScore, time);
        this.firstResult = firstResult;
        this.items = items == null ? Collections.emptyList() : items;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public int getLastResult() {
        return this.firstResult + this.items.size() - 1;
    }

    public int size() {
        return this.items.size();
    }

    public List<T> getItems() {
        return this.items;
    }

    public T get(int index) {
        return this.items.get(this.firstResult + index);
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }
}

