/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lucis.core;

import java.util.ArrayList;
import net.sf.derquinse.lucis.Item;
import net.sf.derquinse.lucis.Page;
import net.sf.derquinse.lucis.Result;
import net.sf.lucis.core.DocMapper;
import net.sf.lucis.core.LucisSearcher;
import net.sf.lucis.core.support.CountingCollector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LucisQuery<T> {
    private LucisQuery() {
    }

    TopDocs getTopDocs(LucisSearcher searcher, Query query, Filter filter, Sort sort, int hits) {
        TopFieldDocs docs;
        if (sort == null) {
            TopDocCollector tdc = new TopDocCollector(hits);
            searcher.search(query, filter, (HitCollector)tdc);
            docs = tdc.topDocs();
        } else {
            docs = searcher.search(query, filter, hits, sort);
        }
        return docs;
    }

    public abstract T perform(LucisSearcher var1);

    public static <T> LucisQuery<Item<T>> first(final Query query, final Filter filter, final Sort sort, final DocMapper<T> mapper) {
        return new LucisQuery<Item<T>>(){

            @Override
            public Item<T> perform(LucisSearcher searcher) {
                Object item;
                float score;
                long t0 = System.currentTimeMillis();
                TopDocs docs = this.getTopDocs(searcher, query, filter, sort, 1);
                if (docs.totalHits > 0) {
                    ScoreDoc sd = docs.scoreDocs[0];
                    score = sd.score;
                    item = mapper.map(sd.doc, score, searcher.doc(sd.doc));
                } else {
                    score = 0.0f;
                    item = null;
                }
                long t1 = System.currentTimeMillis();
                return new Item(docs.totalHits, score, t1 - t0, item);
            }
        };
    }

    public static <T> LucisQuery<Item<T>> first(Query query, Sort sort, DocMapper<T> mapper) {
        return LucisQuery.first(query, null, sort, mapper);
    }

    public static <T> LucisQuery<Item<T>> first(Query query, Filter filter, DocMapper<T> mapper) {
        return LucisQuery.first(query, filter, null, mapper);
    }

    public static <T> LucisQuery<Item<T>> first(Query query, DocMapper<T> mapper) {
        return LucisQuery.first(query, null, null, mapper);
    }

    public static <T> LucisQuery<Page<T>> page(final Query query, final Filter filter, final Sort sort, final DocMapper<T> mapper, final int first, final int pageSize) {
        return new LucisQuery<Page<T>>(){

            @Override
            public Page<T> perform(LucisSearcher searcher) {
                float score;
                ArrayList items;
                int total = first + pageSize;
                long t0 = System.currentTimeMillis();
                TopDocs docs = this.getTopDocs(searcher, query, filter, sort, total);
                if (docs.totalHits > first) {
                    int n = Math.min(total, docs.scoreDocs.length);
                    items = new ArrayList(n - first);
                    score = docs.getMaxScore();
                    for (int i = first; i < n; ++i) {
                        ScoreDoc sd = docs.scoreDocs[i];
                        Object item = mapper.map(sd.doc, score, searcher.doc(sd.doc));
                        items.add(item);
                    }
                } else {
                    score = 0.0f;
                    items = null;
                }
                long t1 = System.currentTimeMillis();
                return new Page(docs.totalHits, score, t1 - t0, first, items);
            }
        };
    }

    public static <T> LucisQuery<Page<T>> page(Query query, Sort sort, DocMapper<T> mapper, int first, int pageSize) {
        return LucisQuery.page(query, null, sort, mapper, first, pageSize);
    }

    public static <T> LucisQuery<Page<T>> page(Query query, Filter filter, DocMapper<T> mapper, int first, int pageSize) {
        return LucisQuery.page(query, filter, null, mapper, first, pageSize);
    }

    public static <T> LucisQuery<Page<T>> page(Query query, DocMapper<T> mapper, int first, int pageSize) {
        return LucisQuery.page(query, null, null, mapper, first, pageSize);
    }

    public static LucisQuery<Result> count(final Query query, final Filter filter) {
        return new LucisQuery<Result>(){

            @Override
            public Result perform(LucisSearcher searcher) {
                long t0 = System.currentTimeMillis();
                CountingCollector collector = new CountingCollector();
                searcher.search(query, filter, collector);
                long t1 = System.currentTimeMillis();
                return new Result(collector.getCount(), collector.getMaxScore(), t1 - t0);
            }
        };
    }
}

