/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lucis.core;

import com.google.common.base.Preconditions;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;

public final class WriterConfiguration {
    private final Analyzer analyzer;
    private final IndexWriter.MaxFieldLength maxFieldLength;

    private WriterConfiguration(Analyzer analyzer, IndexWriter.MaxFieldLength maxFieldLength) {
        this.analyzer = analyzer;
        this.maxFieldLength = maxFieldLength;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public IndexWriter.MaxFieldLength getMaxFieldLength() {
        return this.maxFieldLength;
    }

    public static WriterConfiguration defaultConfiguration() {
        return WriterConfiguration.of((Analyzer)new StandardAnalyzer());
    }

    public static WriterConfiguration of(Analyzer analyzer, IndexWriter.MaxFieldLength length) {
        Preconditions.checkNotNull((Object)analyzer, (Object)"An analyzer must be provided");
        Preconditions.checkNotNull((Object)length, (Object)"Max field length must be provided");
        return new WriterConfiguration(analyzer, length);
    }

    public static WriterConfiguration of(Analyzer analyzer, int length) {
        return WriterConfiguration.of(analyzer, new IndexWriter.MaxFieldLength(length));
    }

    public static WriterConfiguration of(Analyzer analyzer) {
        return WriterConfiguration.of(analyzer, IndexWriter.MaxFieldLength.UNLIMITED);
    }
}

