/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lucis.core.impl;

import com.google.common.base.Supplier;
import java.util.logging.Logger;
import net.sf.lucis.core.ComplexQuery;
import net.sf.lucis.core.LucisQuery;
import net.sf.lucis.core.LucisSearcher;
import net.sf.lucis.core.Queryable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueryable
implements Queryable {
    final <T> T doQuery(Logger logger, LucisSearcher searcher, LucisQuery<T> query) {
        return query.perform(searcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T doQuery(Logger logger, Supplier<LucisSearcher> provider, LucisQuery<T> query) {
        LucisSearcher searcher = (LucisSearcher)provider.get();
        try {
            T t = this.doQuery(logger, searcher, query);
            return t;
        }
        finally {
            searcher.close();
        }
    }

    final <T> T doQuery(final Logger logger, final LucisSearcher searcher, ComplexQuery<T> query) {
        AbstractQueryable queryable = new AbstractQueryable(){

            public <S> S query(LucisQuery<S> inquiry) {
                return this.doQuery(logger, searcher, inquiry);
            }

            public <S> S query(ComplexQuery<S> inquiry) {
                return this.doQuery(logger, searcher, inquiry);
            }
        };
        return query.inquire(queryable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T doQuery(Logger logger, Supplier<LucisSearcher> provider, ComplexQuery<T> query) {
        LucisSearcher searcher = (LucisSearcher)provider.get();
        try {
            T t = this.doQuery(logger, searcher, query);
            return t;
        }
        finally {
            searcher.close();
        }
    }
}

