/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lucis.core.impl;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import net.sf.lucis.core.Adder;
import net.sf.lucis.core.DirectoryProvider;
import net.sf.lucis.core.IndexException;
import net.sf.lucis.core.IndexStatus;
import net.sf.lucis.core.WriterConfiguration;
import net.sf.lucis.core.impl.MayFail;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;

public final class DefaultAdder
implements Adder {
    private final WriterConfiguration config;
    private final DirectoryProvider provider;
    private IndexWriter writer = null;
    private IndexStatus status = IndexStatus.OK;
    private Logger log = Logger.getLogger(this.getClass().getName());

    public DefaultAdder(WriterConfiguration config, DirectoryProvider provider) {
        this.config = (WriterConfiguration)Preconditions.checkNotNull((Object)config, (Object)"A writer configuration must be provided");
        this.provider = (DirectoryProvider)Preconditions.checkNotNull((Object)provider, (Object)"A directory provider must be provided");
    }

    public IndexStatus getStatus() {
        return this.status;
    }

    public void setLogName(String name) {
        this.log = Logger.getLogger(name);
    }

    private void on() {
        Preconditions.checkState((this.writer != null ? 1 : 0) != 0, (Object)"Adder not started");
    }

    public void add(Document document) {
        this.add(document, this.config.getAnalyzer());
    }

    public void add(final Document document, final Analyzer analyzer) {
        this.on();
        try {
            Callable<Object> callable = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    DefaultAdder.this.writer.addDocument(document, analyzer);
                    return null;
                }
            };
            MayFail.run(callable);
        }
        catch (IndexException e) {
            this.status = e.getStatus();
            throw e;
        }
    }

    void start() {
        if (this.writer != null) {
            return;
        }
        final Analyzer analyzer = this.config.getAnalyzer();
        final IndexWriter.MaxFieldLength length = this.config.getMaxFieldLength();
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                DefaultAdder.this.writer = new IndexWriter(DefaultAdder.this.provider.getDirectory(), analyzer, true, length);
                return null;
            }
        };
        this.status = IndexStatus.OK;
        try {
            MayFail.run(callable);
        }
        catch (IndexException e) {
            this.status = e.getStatus();
            throw e;
        }
    }

    void stop() {
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (DefaultAdder.this.status == IndexStatus.OK) {
                    DefaultAdder.this.writer.commit();
                    DefaultAdder.this.writer.optimize();
                } else {
                    DefaultAdder.this.writer.rollback();
                }
                DefaultAdder.this.writer.close();
                return null;
            }
        };
    }
}

