/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lucis.core.impl;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import net.sf.lucis.core.Checkpoint;
import net.sf.lucis.core.Store;
import net.sf.lucis.core.StoreException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSStore<T>
implements Store<T> {
    private static final String CONTROL_FILE = "checkpoint.ctl";
    private final File file;
    private final File control;
    private final FSDirectory directory;
    private final Checkpoint<T> serializer;

    public FSStore(Checkpoint<T> serializer, String indexDir) {
        Preconditions.checkNotNull(serializer, (Object)"A checkpoint serializer must be provided.");
        this.serializer = serializer;
        try {
            this.file = new File(indexDir);
            Preconditions.checkArgument((this.file.exists() && this.file.isDirectory() ? 1 : 0) != 0, (Object)"Invalid index directory");
            this.control = new File(this.file, CONTROL_FILE);
            Preconditions.checkArgument((!this.control.isDirectory() ? 1 : 0) != 0, (Object)"Control file cannot be a directory");
            this.directory = FSDirectory.getDirectory((File)this.file);
        }
        catch (IOException e) {
            throw new StoreException(e);
        }
    }

    @Override
    public Directory getDirectory() {
        return this.directory;
    }

    private void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T getCheckpoint() {
        if (!this.control.exists()) {
            return null;
        }
        try {
            FileInputStream stream = new FileInputStream(this.control);
            try {
                T t = this.serializer.read(stream);
                return t;
            }
            finally {
                this.close(stream);
            }
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
        catch (IOException e) {
            throw new StoreException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCheckpoint(T checkpoint) {
        try {
            FileOutputStream fos = new FileOutputStream(this.control, false);
            try {
                this.serializer.write(checkpoint, fos);
            }
            finally {
                this.close(fos);
            }
        }
        catch (IOException e) {
            throw new StoreException(e);
        }
    }

    @Override
    public Object getVersion() {
        try {
            return this.getCheckpoint();
        }
        catch (StoreException e) {
            return null;
        }
    }
}

