/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lucis.core.impl;

import java.io.IOException;
import java.util.concurrent.Callable;
import net.sf.lucis.core.IndexException;
import net.sf.lucis.core.IndexStatus;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.LockObtainFailedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MayFail<T> {
    private MayFail() {
    }

    public abstract IndexStatus getStatus();

    public T getResult() {
        throw new UnsupportedOperationException();
    }

    public IndexException getException() {
        throw new UnsupportedOperationException();
    }

    public static <V> V run(Callable<V> callabe) {
        try {
            return callabe.call();
        }
        catch (LockObtainFailedException le) {
            throw new IndexException(IndexStatus.LOCKED, (Throwable)le);
        }
        catch (CorruptIndexException ce) {
            throw new IndexException(IndexStatus.CORRUPT, (Throwable)ce);
        }
        catch (IOException ioe) {
            throw new IndexException(IndexStatus.IOERROR, (Throwable)ioe);
        }
        catch (Exception e) {
            throw new IndexException(IndexStatus.ERROR, (Throwable)e);
        }
    }

    public static <V> MayFail<V> of(Callable<V> callabe) {
        try {
            final V result = MayFail.run(callabe);
            return new MayFail<V>(){

                @Override
                public IndexStatus getStatus() {
                    return IndexStatus.OK;
                }

                @Override
                public V getResult() {
                    return result;
                }
            };
        }
        catch (IndexException e) {
            return new MayFail<V>(){

                @Override
                public IndexStatus getStatus() {
                    return e.getStatus();
                }

                @Override
                public IndexException getException() {
                    return e;
                }
            };
        }
    }
}

