/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lucis.core.impl;

import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.sf.derquinsej.concurrent.ActiveObjectStatus;
import net.sf.derquinsej.concurrent.ActiveObjectSupport;
import net.sf.lucis.core.Delays;
import net.sf.lucis.core.FullIndexer;
import net.sf.lucis.core.IndexException;
import net.sf.lucis.core.IndexStatus;
import net.sf.lucis.core.IndexerService;
import net.sf.lucis.core.ReindexingStore;
import net.sf.lucis.core.ReindexingWriter;
import net.sf.lucis.core.impl.MayFail;

public class ReindexingIndexerService
implements IndexerService {
    private final ReindexingWriter writer;
    private volatile IndexStatus status = IndexStatus.OK;
    private final ReindexingStore store;
    private final FullIndexer indexer;
    private final ActiveObjectSupport support;
    private volatile ScheduledExecutorService executor;
    private volatile Delays delays = Delays.constant(600000L);
    private Logger log = Logger.getLogger(this.getClass().getName());

    public ReindexingIndexerService(ReindexingStore store, ReindexingWriter writer, FullIndexer indexer) {
        this.store = store;
        this.writer = writer;
        this.indexer = indexer;
        Runnable onStart = new Runnable(){

            public void run() {
                ReindexingIndexerService.this.executor = Executors.newSingleThreadScheduledExecutor();
                ReindexingIndexerService.this.schedule(0L);
            }
        };
        Runnable onStop = new Runnable(){

            public void run() {
                ScheduledExecutorService ses = ReindexingIndexerService.this.executor;
                if (ses != null) {
                    ReindexingIndexerService.this.executor = null;
                    ses.shutdown();
                    try {
                        while (!ses.isTerminated()) {
                            ses.awaitTermination(5L, TimeUnit.SECONDS);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        };
        this.support = new ActiveObjectSupport(onStart, null, onStop);
    }

    public void setLogName(String name) {
        this.log = Logger.getLogger(name);
    }

    public void setDelays(Delays delays) {
        this.delays = delays;
    }

    public IndexStatus getIndexStatus() {
        return this.status;
    }

    public ActiveObjectStatus getStatus() {
        return this.support.getStatus();
    }

    public void start() {
        this.support.start();
    }

    public void stop() {
        this.support.stop();
    }

    private void schedule(long delay) {
        ScheduledExecutorService ses = this.executor;
        if (ses != null) {
            ses.schedule(new Task(), delay, TimeUnit.MILLISECONDS);
        }
    }

    private void schedule(IndexStatus status, long delay) {
        this.status = status;
        this.schedule(delay);
    }

    private final class Task
    implements Runnable {
        private Task() {
        }

        public void run() {
            Callable<Object> callable = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    ReindexingIndexerService.this.writer.reindex(ReindexingIndexerService.this.store, ReindexingIndexerService.this.indexer);
                    return null;
                }
            };
            try {
                MayFail.run(callable);
                ReindexingIndexerService.this.schedule(IndexStatus.OK, ReindexingIndexerService.this.delays.getNormal());
            }
            catch (IndexException e) {
                ReindexingIndexerService.this.schedule(e.getStatus(), ReindexingIndexerService.this.delays.getError());
            }
            catch (Exception ex) {
                ReindexingIndexerService.this.schedule(IndexStatus.ERROR, ReindexingIndexerService.this.delays.getError());
            }
        }
    }
}

