/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lucis.core.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import net.sf.derquinse.lucis.IndexNotAvailableException;
import net.sf.lucis.core.DirectoryProvider;
import net.sf.lucis.core.LucisSearcher;
import net.sf.lucis.core.impl.AbstractSearcher;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.store.Directory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingleSearcherProvider
implements Supplier<LucisSearcher> {
    public static SingleSearcherProvider of(final Directory directory) {
        Preconditions.checkNotNull((Object)directory);
        return new SingleSearcherProvider(){

            Directory directory() {
                return directory;
            }
        };
    }

    public static SingleSearcherProvider of(final DirectoryProvider provider) {
        Preconditions.checkNotNull((Object)provider);
        return new SingleSearcherProvider(){

            Directory directory() {
                return provider.getDirectory();
            }
        };
    }

    private SingleSearcherProvider() {
    }

    abstract Directory directory();

    public LucisSearcher get() {
        try {
            IndexReader reader = IndexReader.open((Directory)this.directory(), (boolean)true);
            IndexSearcher searcher = new IndexSearcher(reader);
            return new SingleSearcher(searcher);
        }
        catch (Exception e) {
            throw new IndexNotAvailableException((Throwable)e);
        }
    }

    private static final class SingleSearcher
    extends AbstractSearcher {
        private final IndexSearcher searcher;

        private SingleSearcher(IndexSearcher searcher) {
            this.searcher = searcher;
        }

        Searcher searcher() {
            return this.searcher;
        }

        public void close() {
            this.close(this.searcher, true);
        }
    }
}

