/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lucis.core.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.lucis.core.support.CountingCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AllCollector
extends CountingCollector
implements Iterable<Integer> {
    private static final int DEFAULT_TRANCHE_SIZE = 4096;
    private final int trancheSize;
    private final List<int[]> tranches = Lists.newLinkedList();
    private int[] current;
    private int index;

    public AllCollector(int trancheSize) {
        Preconditions.checkArgument((trancheSize > 0 ? 1 : 0) != 0);
        this.trancheSize = trancheSize;
        this.reset();
    }

    public AllCollector() {
        this(4096);
    }

    @Override
    public void collect(int doc, float score) {
        super.collect(doc, score);
        if (this.current == null) {
            this.current = new int[this.trancheSize];
            this.index = 0;
            this.tranches.add(this.current);
        }
        this.current[this.index] = doc;
        ++this.index;
        if (this.index == this.trancheSize) {
            this.current = null;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.tranches.clear();
        this.current = null;
        this.index = 0;
    }

    public IntIterator intIterator() {
        return new IntIterator();
    }

    @Override
    public Iterator<Integer> iterator() {
        final IntIterator ii = this.intIterator();
        return new Iterator<Integer>(){

            @Override
            public boolean hasNext() {
                return ii.hasNext();
            }

            @Override
            public Integer next() {
                return ii.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public class IntIterator {
        private final int count;
        private int totalIndex;
        private int trancheIndex;
        private int[] currentTranche;
        private final Iterator<int[]> iterator;

        private IntIterator() {
            this.count = AllCollector.this.getCount();
            this.totalIndex = 0;
            this.trancheIndex = 0;
            this.currentTranche = null;
            this.iterator = AllCollector.this.tranches.iterator();
        }

        private void check() {
            if (this.count != AllCollector.this.getCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean hasNext() {
            this.check();
            return this.totalIndex < this.count;
        }

        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.currentTranche == null) {
                this.currentTranche = this.iterator.next();
                this.trancheIndex = 0;
            }
            int element = this.currentTranche[this.trancheIndex];
            ++this.totalIndex;
            ++this.trancheIndex;
            if (this.trancheIndex == AllCollector.this.trancheSize) {
                this.currentTranche = null;
            }
            return element;
        }
    }
}

