/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lucis.core.support;

import org.apache.lucene.search.HitCollector;

public class CountingCollector
extends HitCollector {
    private float maxScore;
    private int count;

    public CountingCollector() {
        this.reset();
    }

    public void collect(int doc, float score) {
        ++this.count;
        this.maxScore = Math.max(this.maxScore, score);
    }

    public void reset() {
        this.maxScore = Float.MIN_VALUE;
        this.count = 0;
    }

    public final int getCount() {
        return this.count;
    }

    public final float getMaxScore() {
        return this.maxScore;
    }
}

