/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lucis.core;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Batch<T> {
    private static final Function<Map.Entry<String, String>, Term> TERM_BUILDER = new Function<Map.Entry<String, String>, Term>(){

        public Term apply(Map.Entry<String, String> entry) {
            return new Term(entry.getKey(), entry.getValue());
        }
    };
    private final T checkpoint;
    private final ImmutableList<Addition> additions;
    private final ImmutableMultimap<String, String> deletions;

    private Batch(T checkpoint, Builder<T> builder) {
        this.checkpoint = checkpoint;
        this.additions = ImmutableList.copyOf((Iterable)((Builder)builder).additions);
        this.deletions = ((Builder)builder).deletions.build();
    }

    public boolean isEmpty() {
        return this.additions.isEmpty() && this.deletions.isEmpty();
    }

    public T getCheckpoint() {
        return this.checkpoint;
    }

    public ImmutableList<Addition> getAdditions() {
        return this.additions;
    }

    public Iterable<Term> getDeletions() {
        return Iterables.transform((Iterable)this.deletions.entries(), TERM_BUILDER);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static final class Addition {
        private final Document document;
        private final Analyzer analyzer;

        private Addition(Document document, Analyzer analyzer) {
            this.document = document;
            this.analyzer = analyzer;
        }

        private Addition(Document document) {
            this(document, (Analyzer)null);
        }

        public Document getDocument() {
            return this.document;
        }

        public Analyzer getAnalyzer() {
            return this.analyzer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<T> {
        private final List<Addition> additions = Lists.newLinkedList();
        private final ImmutableMultimap.Builder<String, String> deletions = ImmutableMultimap.builder();

        private Builder() {
        }

        public Builder<T> add(Document document) {
            if (document != null) {
                this.additions.add(new Addition(document));
            }
            return this;
        }

        public Builder<T> add(Document document, Analyzer analyzer) {
            if (document != null) {
                this.additions.add(new Addition(document, analyzer));
            }
            return this;
        }

        public Builder<T> delete(String field, String text) {
            if (field != null && text != null) {
                this.deletions.put((Object)field, (Object)text);
            }
            return this;
        }

        public Builder<T> delete(Term term) {
            if (term != null) {
                return this.delete(term.field(), term.text());
            }
            return this;
        }

        public Builder<T> update(Document document, String field, String text) {
            if (field != null && text != null) {
                return this.delete(field, text).add(document);
            }
            return this;
        }

        public Builder<T> update(Document document, Term term) {
            if (term != null) {
                return this.update(document, term.field(), term.text());
            }
            return this;
        }

        public Batch<T> build(T checkpoint) {
            if (checkpoint == null) {
                return null;
            }
            return new Batch(checkpoint, this);
        }
    }
}

