/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lucis.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import net.sf.lucis.core.Checkpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Checkpoints {
    private static final String UTF8 = "UTF-8";
    private static final Checkpoint<String> UTF8LINE = new Checkpoint<String>(){

        @Override
        public String read(InputStream input) throws IOException {
            BufferedReader br = new BufferedReader(new InputStreamReader(input, Checkpoints.UTF8));
            String checkpoint = br.readLine();
            return checkpoint;
        }

        @Override
        public void write(String checkpoint, OutputStream output) throws IOException {
            if (checkpoint != null) {
                PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(output, Checkpoints.UTF8), true);
                pw.println(checkpoint);
            }
        }
    };
    private static final Checkpoint<Long> LONG = new Checkpoint<Long>(){

        @Override
        public Long read(InputStream input) throws IOException {
            String s = (String)UTF8LINE.read(input);
            if (s != null) {
                return Long.parseLong(s);
            }
            return null;
        }

        @Override
        public void write(Long checkpoint, OutputStream output) throws IOException {
            if (checkpoint != null) {
                UTF8LINE.write(checkpoint.toString(), output);
            }
        }
    };

    private Checkpoints() {
        throw new AssertionError();
    }

    public static final Checkpoint<Long> ofLong() {
        return LONG;
    }

    public static final Checkpoint<String> ofStringLine() {
        return UTF8LINE;
    }
}

