/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lucis.core.impl;

import java.io.IOException;
import net.sf.derquinse.lucis.SearchException;
import net.sf.lucis.core.LucisSearcher;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopFieldDocs;

public abstract class AbstractSearcher
implements LucisSearcher {
    AbstractSearcher() {
    }

    abstract Searcher searcher();

    public final Document doc(int i) {
        try {
            return this.searcher().doc(i);
        }
        catch (CorruptIndexException e) {
            throw new SearchException((Throwable)e);
        }
        catch (IOException e) {
            throw new SearchException((Throwable)e);
        }
    }

    public final void search(Query query, Filter filter, HitCollector results) {
        try {
            this.searcher().search(query, filter, results);
        }
        catch (IOException e) {
            throw new SearchException((Throwable)e);
        }
    }

    public final TopFieldDocs search(Query query, Filter filter, int n, Sort sort) {
        try {
            return this.searcher().search(query, filter, n, sort);
        }
        catch (IOException e) {
            throw new SearchException((Throwable)e);
        }
    }

    final void close(IndexSearcher searcher, boolean reader) {
        if (reader) {
            IndexReader ir = searcher.getIndexReader();
            try {
                ir.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            searcher.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

