/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lucis.core.impl;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.sf.derquinsej.concurrent.ActiveObjectStatus;
import net.sf.derquinsej.concurrent.ActiveObjectSupport;
import net.sf.lucis.core.Batch;
import net.sf.lucis.core.Delays;
import net.sf.lucis.core.IndexStatus;
import net.sf.lucis.core.Indexer;
import net.sf.lucis.core.IndexerService;
import net.sf.lucis.core.Store;
import net.sf.lucis.core.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIndexerService<T>
implements IndexerService {
    private final Writer writer;
    private volatile IndexStatus status = IndexStatus.OK;
    private final Store<T> store;
    private final Indexer<T> indexer;
    private final ActiveObjectSupport support;
    private volatile ScheduledExecutorService executor;
    private volatile Delays delays = Delays.constant(1000L);
    private Logger log = Logger.getLogger(this.getClass().getName());

    public DefaultIndexerService(Store<T> store, Writer writer, Indexer<T> indexer) {
        this.store = store;
        this.writer = writer;
        this.indexer = indexer;
        Runnable onStart = new Runnable(){

            public void run() {
                DefaultIndexerService.this.executor = Executors.newSingleThreadScheduledExecutor();
                DefaultIndexerService.this.schedule(0L);
            }
        };
        Runnable onStop = new Runnable(){

            public void run() {
                ScheduledExecutorService ses = DefaultIndexerService.this.executor;
                if (ses != null) {
                    DefaultIndexerService.this.executor = null;
                    ses.shutdown();
                    try {
                        while (!ses.isTerminated()) {
                            ses.awaitTermination(5L, TimeUnit.SECONDS);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        };
        this.support = new ActiveObjectSupport(onStart, null, onStop);
    }

    public void setLogName(String name) {
        this.log = Logger.getLogger(name);
    }

    public void setDelays(Delays delays) {
        this.delays = delays;
    }

    @Override
    public IndexStatus getIndexStatus() {
        return this.status;
    }

    @Override
    public ActiveObjectStatus getStatus() {
        return this.support.getStatus();
    }

    @Override
    public void start() {
        this.support.start();
    }

    @Override
    public void stop() {
        this.support.stop();
    }

    private void schedule(long delay) {
        ScheduledExecutorService ses = this.executor;
        if (ses != null) {
            ses.schedule(new Task(), delay, TimeUnit.MILLISECONDS);
        }
    }

    private void schedule(IndexStatus status, long delay) {
        this.status = status;
        this.schedule(delay);
    }

    private final class Task
    implements Runnable {
        private Task() {
        }

        public void run() {
            Object checkpoint;
            try {
                checkpoint = DefaultIndexerService.this.store.getCheckpoint();
            }
            catch (Exception e) {
                DefaultIndexerService.this.schedule(IndexStatus.ERROR, DefaultIndexerService.this.delays.getError());
                return;
            }
            try {
                Batch batch = DefaultIndexerService.this.indexer.index(checkpoint);
                if (batch == null) {
                    DefaultIndexerService.this.schedule(DefaultIndexerService.this.delays.getIdle());
                } else {
                    IndexStatus status = DefaultIndexerService.this.writer.write(DefaultIndexerService.this.store, batch);
                    if (status == null) {
                        DefaultIndexerService.this.schedule(DefaultIndexerService.this.delays.getIdle());
                    } else {
                        DefaultIndexerService.this.schedule(status, DefaultIndexerService.this.delays.getNormal());
                    }
                }
            }
            catch (RuntimeException e) {
                DefaultIndexerService.this.schedule(DefaultIndexerService.this.delays.getError());
            }
        }
    }
}

