/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lucis.core.impl;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import net.sf.lucis.core.Adder;
import net.sf.lucis.core.FullIndexer;
import net.sf.lucis.core.IndexException;
import net.sf.lucis.core.IndexStatus;
import net.sf.lucis.core.ReindexingStore;
import net.sf.lucis.core.ReindexingWriter;
import net.sf.lucis.core.WriterConfiguration;
import net.sf.lucis.core.impl.MayFail;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;

public final class DefaultReindexingWriter
implements ReindexingWriter {
    private final WriterConfiguration config;
    private Logger log = Logger.getLogger(this.getClass().getName());

    public DefaultReindexingWriter() {
        this(WriterConfiguration.defaultConfiguration());
    }

    public DefaultReindexingWriter(WriterConfiguration config) {
        this.config = (WriterConfiguration)Preconditions.checkNotNull((Object)config, (Object)"A writer configuration must be provided");
    }

    public void setLogName(String name) {
        this.log = Logger.getLogger(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindex(ReindexingStore store, FullIndexer indexer) {
        AdderImpl adder = new AdderImpl(store.getDestinationDirectory());
        try {
            indexer.index(adder);
            store.reindexed();
        }
        finally {
            adder.done();
        }
    }

    private class AdderImpl
    implements Adder {
        private final IndexWriter writer;
        private IndexStatus status = IndexStatus.OK;
        private boolean done = false;

        private AdderImpl(final Directory directory) {
            final Analyzer analyzer = DefaultReindexingWriter.this.config.getAnalyzer();
            final IndexWriter.MaxFieldLength length = DefaultReindexingWriter.this.config.getMaxFieldLength();
            Callable<IndexWriter> callable = new Callable<IndexWriter>(){

                @Override
                public IndexWriter call() throws Exception {
                    return new IndexWriter(directory, analyzer, true, length);
                }
            };
            this.writer = MayFail.run(callable);
        }

        public IndexStatus getStatus() {
            return this.status;
        }

        private void on() {
            Preconditions.checkState((!this.done ? 1 : 0) != 0, (Object)"Adder already closed");
        }

        public void add(Document document) {
            this.add(document, DefaultReindexingWriter.this.config.getAnalyzer());
        }

        public void add(final Document document, final Analyzer analyzer) {
            this.on();
            try {
                Callable<Object> callable = new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        AdderImpl.this.writer.addDocument(document, analyzer);
                        return null;
                    }
                };
                MayFail.run(callable);
            }
            catch (IndexException e) {
                this.status = e.getStatus();
                throw e;
            }
        }

        private void done() {
            this.done = true;
            Callable<Object> callable = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    if (AdderImpl.this.status == IndexStatus.OK) {
                        AdderImpl.this.writer.commit();
                        AdderImpl.this.writer.optimize();
                    } else {
                        AdderImpl.this.writer.rollback();
                    }
                    AdderImpl.this.writer.close();
                    return null;
                }
            };
            MayFail.run(callable);
        }
    }
}

