/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lucis.core.impl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.logging.Logger;
import net.sf.lucis.core.Batch;
import net.sf.lucis.core.IndexStatus;
import net.sf.lucis.core.Store;
import net.sf.lucis.core.Writer;
import net.sf.lucis.core.WriterConfiguration;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.LockObtainFailedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultWriter
implements Writer {
    private final WriterConfiguration config;
    private Logger log = Logger.getLogger(this.getClass().getName());

    public DefaultWriter() {
        this(WriterConfiguration.defaultConfiguration());
    }

    public DefaultWriter(WriterConfiguration config) {
        Preconditions.checkNotNull((Object)config, (Object)"A writer configuration must be provided");
        this.config = config;
    }

    public void setLogName(String name) {
        this.log = Logger.getLogger(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> IndexStatus write(Store<T> store, Batch<T> batch) {
        Preconditions.checkNotNull(store, (Object)"A destination store must be provided.");
        if (batch == null) {
            return null;
        }
        try {
            T oldCP = store.getCheckpoint();
            T newCP = batch.getCheckpoint();
            if (Objects.equal(oldCP, newCP)) {
                return null;
            }
            if (!batch.isEmpty()) {
                Analyzer analyzer = this.config.getAnalyzer();
                IndexWriter.MaxFieldLength length = this.config.getMaxFieldLength();
                IndexWriter writer = new IndexWriter(store.getDirectory(), analyzer, length);
                boolean ok = false;
                try {
                    for (Term term : batch.getDeletions()) {
                        writer.deleteDocuments(term);
                    }
                    for (Batch.Addition addition : batch.getAdditions()) {
                        writer.addDocument(addition.getDocument(), (Analyzer)Objects.firstNonNull((Object)addition.getAnalyzer(), (Object)analyzer));
                    }
                    writer.commit();
                    ok = true;
                    writer.optimize();
                }
                finally {
                    if (!ok) {
                        this.rollback(writer);
                    }
                }
                writer.close();
            }
            store.setCheckpoint(newCP);
            return IndexStatus.OK;
        }
        catch (LockObtainFailedException le) {
            return IndexStatus.LOCKED;
        }
        catch (CorruptIndexException ce) {
            return IndexStatus.CORRUPT;
        }
        catch (IOException ioe) {
            return IndexStatus.IOERROR;
        }
        catch (Exception e) {
            return IndexStatus.ERROR;
        }
    }

    private void rollback(IndexWriter writer) {
        try {
            writer.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

