/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lucis.core.impl;

import com.google.common.base.Preconditions;
import net.sf.lucis.core.Store;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAMStore<T>
implements Store<T> {
    private final RAMDirectory directory;
    private T checkpoint;

    public RAMStore(Store<T> store) throws Exception {
        Preconditions.checkNotNull(store, (Object)"A source store must be provided.");
        this.checkpoint = store.getCheckpoint();
        this.directory = new RAMDirectory(store.getDirectory());
    }

    public RAMStore() {
        this.directory = new RAMDirectory();
        this.checkpoint = null;
    }

    @Override
    public Directory getDirectory() {
        return this.directory;
    }

    @Override
    public T getCheckpoint() {
        return this.checkpoint;
    }

    @Override
    public Object getVersion() {
        return this.checkpoint;
    }

    @Override
    public void setCheckpoint(T checkpoint) {
        Preconditions.checkNotNull(checkpoint, (Object)"A checkpoint must be provided.");
        this.checkpoint = checkpoint;
    }
}

