/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lucis.core.impl;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import net.sf.lucis.core.Checkpoints;
import net.sf.lucis.core.ReindexingStore;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class ReindexingFSStore
implements ReindexingStore {
    private static final String STATUS_FILE = "status.ctl";
    private static final String COPY01 = "copy01";
    private static final String COPY02 = "copy02";
    private final File file;
    private final File statusFile;
    private Status status = Status.NULL;
    private final Copy copy01;
    private final Copy copy02;
    private final AtomicLong version = new AtomicLong(0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Status readStatus(File file) {
        if (!file.exists()) {
            return Status.NULL;
        }
        try {
            FileInputStream stream = new FileInputStream(file);
            try {
                String str = Checkpoints.ofStringLine().read(stream);
                if (str == null || str.length() == 0) {
                    Status status2 = Status.NULL;
                    return status2;
                }
                Status status = Enum.valueOf(Status.class, str);
                return status;
            }
            finally {
                ReindexingFSStore.close(stream);
            }
        }
        catch (FileNotFoundException fnfe) {
            return Status.NULL;
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }

    private static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ReindexingFSStore(String indexDir) {
        try {
            this.file = new File(indexDir);
            Preconditions.checkArgument((this.file.exists() && this.file.isDirectory() ? 1 : 0) != 0, (Object)"Invalid index directory");
            this.statusFile = new File(this.file, STATUS_FILE);
            Preconditions.checkArgument((!this.statusFile.isDirectory() ? 1 : 0) != 0, (Object)"Status file cannot be a directory");
            this.copy01 = new Copy(this.file, COPY01);
            this.copy02 = new Copy(this.file, COPY02);
            this.status = ReindexingFSStore.readStatus(this.file);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Directory getDirectory() {
        switch (this.status) {
            case NULL: {
                return null;
            }
            case CREATING: {
                return this.copy01.directory;
            }
            case DONE01: {
                return this.copy01.directory;
            }
            case DONE02: {
                return this.copy02.directory;
            }
        }
        throw new AssertionError();
    }

    public Directory getDestinationDirectory() {
        switch (this.status) {
            case DONE01: {
                return this.copy02.directory;
            }
        }
        return this.copy01.directory;
    }

    public void reindexed() {
        switch (this.status) {
            case DONE01: {
                this.status = Status.DONE02;
                break;
            }
            default: {
                this.status = Status.DONE01;
            }
        }
        this.version.incrementAndGet();
        this.writeStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStatus() {
        try {
            FileOutputStream fos = new FileOutputStream(this.statusFile, false);
            try {
                Checkpoints.ofStringLine().write(this.status.name(), fos);
            }
            finally {
                ReindexingFSStore.close(fos);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object getVersion() {
        return this.version.get();
    }

    private static final class Copy {
        private final File file;
        private final Directory directory;

        Copy(File base, String path) throws IOException {
            this.file = new File(base, path);
            Preconditions.checkArgument((!this.file.exists() || this.file.exists() && this.file.isDirectory() ? 1 : 0) != 0, (Object)"Invalid index copy directory");
            if (!this.file.exists()) {
                this.file.mkdir();
            }
            this.directory = FSDirectory.getDirectory((File)this.file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status {
        NULL,
        CREATING,
        DONE01,
        DONE02;

    }
}

