/*
 * Decompiled with CFR 0.152.
 */
package net.matrix.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.matrix.text.MessageFormats;
import net.matrix.text.Resources;
import net.matrix.util.IterableIterator;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;

public final class HierarchicalConfigurationUtils {
    private static final String RESOURCE_BASENAME = "net.matrix.configuration.Messages";

    private HierarchicalConfigurationUtils() {
    }

    public static Map<String, String> parseParameter(HierarchicalConfiguration config, String subKey, String nameKey, String valueKey) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (HierarchicalConfiguration subConfig : config.configurationsAt(subKey)) {
            String name = subConfig.getString(nameKey);
            String value = subConfig.getString(valueKey);
            parameters.put(name, value);
        }
        return parameters;
    }

    public static void updateParameter(HierarchicalConfiguration config, String subKey, String nameKey, String valueKey, Map<String, String> parameters) {
        for (HierarchicalConfiguration subConfig : config.configurationsAt(subKey)) {
            subConfig.clear();
        }
        String newNameKey = subKey + "(-1)." + nameKey;
        String newValueKey = subKey + "." + valueKey;
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            config.addProperty(newNameKey, (Object)parameter.getKey());
            config.addProperty(newValueKey, (Object)parameter.getValue());
        }
    }

    public static Map<String, String> parseAttributes(HierarchicalConfiguration config) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String key : new IterableIterator(config.getKeys())) {
            String value = config.getString(key);
            parameters.put(key, value);
        }
        return parameters;
    }

    public static List<String> listAllNames(HierarchicalConfiguration config, String subKey, String nameKey) {
        ArrayList<String> names = new ArrayList<String>();
        for (HierarchicalConfiguration subConfig : config.configurationsAt(subKey)) {
            String name = subConfig.getString(nameKey);
            names.add(name);
        }
        return names;
    }

    public static HierarchicalConfiguration findForName(HierarchicalConfiguration config, String subKey, String nameKey, String nameValue) throws ConfigurationException {
        for (HierarchicalConfiguration subConfig : config.configurationsAt(subKey)) {
            String name = subConfig.getString(nameKey);
            if (!name.equals(nameValue)) continue;
            return subConfig;
        }
        throw new ConfigurationException(MessageFormats.format(Resources.getBundle(RESOURCE_BASENAME), "subnodeNotFound", nameKey, nameValue, subKey));
    }
}

