/*
 * Decompiled with CFR 0.152.
 */
package net.matrix.configuration;

import java.io.IOException;
import net.matrix.configuration.ConfigurationReloadingListener;
import net.matrix.configuration.ReloadableConfigurationContainer;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class XMLConfigurationContainer
implements ReloadableConfigurationContainer<XMLConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(XMLConfigurationContainer.class);
    private XMLConfiguration config = new XMLConfiguration();

    public XMLConfigurationContainer() {
        this.config.setDelimiterParsingDisabled(this.isDelimiterParsingDisabled());
    }

    @Override
    public void load(Resource resource) throws ConfigurationException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("\u52a0\u8f7d\u914d\u7f6e\uff1a" + resource);
        }
        try {
            this.config.load(resource.getFile());
            this.config.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy());
            this.config.addConfigurationListener((ConfigurationListener)new ConfigurationReloadingListener(this));
        }
        catch (IOException e) {
            try {
                this.config.load(resource.getInputStream());
            }
            catch (IOException ise) {
                throw new ConfigurationException((Throwable)ise);
            }
        }
        this.reset();
    }

    protected boolean isDelimiterParsingDisabled() {
        return false;
    }

    @Override
    public void reload() {
        this.config.reload();
    }

    @Override
    public void checkReload() {
        this.config.reload();
    }

    @Override
    public void reset() {
        LOG.debug(this.getClass().getName() + ": \u91cd\u65b0\u52a0\u8f7d");
    }

    @Override
    public XMLConfiguration getConfig() {
        return this.config;
    }
}

