/*
 * Decompiled with CFR 0.152.
 */
package net.matrix.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.matrix.data.Tree;
import net.matrix.data.TreeSource;

public class DefaultTree<ID, DATA>
implements Serializable,
Tree<ID, DATA> {
    private static final long serialVersionUID = -21200598521077549L;
    private Tree.Key key;
    private ID id;
    private DATA data;
    private DefaultTree<ID, DATA> parent;
    private Map<ID, Tree.Key> keyMap;
    private SortedMap<Tree.Key, DefaultTree<ID, DATA>> nodes;

    public DefaultTree(ID id, DATA data) {
        this.key = new DefaultKey();
        this.id = id;
        this.data = data;
        this.parent = null;
        this.keyMap = new HashMap<ID, Tree.Key>();
        this.nodes = Collections.synchronizedSortedMap(new TreeMap());
        this.keyMap.put(id, this.key);
        this.nodes.put(this.key, this);
    }

    public DefaultTree(DefaultTree<ID, DATA> parent, ID id, DATA data) {
        this.key = new DefaultKey(parent.key, parent.getChildNodes().size());
        this.id = id;
        this.data = data;
        this.parent = parent;
        this.keyMap = parent.keyMap;
        this.nodes = parent.nodes;
        this.keyMap.put(id, this.key);
        this.nodes.put(this.key, this);
    }

    @Override
    public Tree.Key getKey() {
        return this.key;
    }

    @Override
    public void setId(ID id) {
        this.id = id;
    }

    @Override
    public ID getId() {
        return this.id;
    }

    @Override
    public void setData(DATA data) {
        this.data = data;
    }

    @Override
    public DATA getData() {
        return this.data;
    }

    @Override
    public Tree.Key findKey(ID nodeId) {
        return this.keyMap.get(nodeId);
    }

    @Override
    public DefaultTree<ID, DATA> getParent() {
        return this.parent;
    }

    @Override
    public SortedMap<Tree.Key, DefaultTree<ID, DATA>> getAllNodes() {
        return this.nodes;
    }

    @Override
    public SortedMap<Tree.Key, DefaultTree<ID, DATA>> getChildNodes() {
        return this.nodes.subMap(new DefaultKey(this.key, 0), new DefaultKey(this.key, Integer.MAX_VALUE));
    }

    @Override
    public DefaultTree<ID, DATA> getNode(Tree.Key nodeKey) {
        return (DefaultTree)this.nodes.get(nodeKey);
    }

    @Override
    public DefaultTree<ID, DATA> getNode(ID nodeId) {
        Tree.Key nodeKey = this.findKey(nodeId);
        if (nodeKey == null) {
            return null;
        }
        return this.getNode(nodeKey);
    }

    @Override
    public DefaultTree<ID, DATA> getChildNode(Tree.Key nodeKey) {
        return (DefaultTree)this.getChildNodes().get(nodeKey);
    }

    @Override
    public DefaultTree<ID, DATA> getChildNode(ID nodeId) {
        Tree.Key nodeKey = this.findKey(nodeId);
        if (nodeKey == null) {
            return null;
        }
        return this.getChildNode(nodeKey);
    }

    @Override
    public DefaultTree<ID, DATA> appendChildNode(ID nodeId, DATA nodeData) {
        return new DefaultTree<ID, DATA>(this, nodeId, nodeData);
    }

    @Override
    public void removeChildNode(Tree.Key nodeKey) {
        Tree node = this.getChildNode(nodeKey);
        if (node == null) {
            return;
        }
        for (Tree.Key childKey : new HashSet<Tree.Key>(((DefaultTree)node).getChildNodes().keySet())) {
            ((DefaultTree)node).removeChildNode(childKey);
        }
        this.keyMap.remove(((DefaultTree)node).id);
        this.nodes.remove(nodeKey);
    }

    @Override
    public void removeChildNode(ID nodeId) {
        Tree.Key nodeKey = this.findKey(nodeId);
        if (nodeKey == null) {
            return;
        }
        this.removeChildNode(nodeKey);
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildNodes().isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append("[id=").append(this.id);
        sb.append(",key=").append(this.key);
        sb.append(",parent=").append(this.parent == null ? "null" : this.parent.getKey());
        sb.append(",data=").append(this.data).append(",subnodes=").append(this.getChildNodes().values()).append("]");
        return sb.toString();
    }

    public static <ID, DATA> DefaultTree<ID, DATA> generate(TreeSource<ID, DATA> source) {
        ID rootId = source.getRootId();
        DATA rootData = source.getItem(rootId);
        DefaultTree<ID, DATA> tree = new DefaultTree<ID, DATA>(rootId, rootData);
        DefaultTree.generateSubNode(source, tree);
        return tree;
    }

    private static <ID, DATA> void generateSubNode(TreeSource<ID, DATA> source, DefaultTree<ID, DATA> node) {
        List<ID> items = source.listChildrenId(node.getId());
        if (items == null || items.size() == 0) {
            return;
        }
        for (ID ID : items) {
            DATA item = source.getItem(ID);
            node.appendChildNode((Object)ID, (Object)item);
        }
        for (DefaultTree defaultTree : new ArrayList<DefaultTree<ID, DATA>>(node.getChildNodes().values())) {
            DefaultTree.generateSubNode(source, defaultTree);
        }
    }

    public static class DefaultKey
    implements Tree.Key {
        private static final long serialVersionUID = 35507229935965284L;
        private Tree.Key parent;
        private int level;
        private int index;
        private int hash;
        private String string;

        public DefaultKey() {
            this(0);
        }

        private DefaultKey(int index) {
            this.parent = null;
            this.level = 0;
            this.index = index;
        }

        public DefaultKey(Tree.Key parent, int index) {
            this.parent = parent;
            this.level = parent.getLevel() + 1;
            this.index = index;
        }

        @Override
        public Tree.Key getParent() {
            return this.parent;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        public int compareTo(Tree.Key o) {
            int p;
            if (this.level < o.getLevel()) {
                return -1;
            }
            if (this.level > o.getLevel()) {
                return 1;
            }
            if (this.level != 0 && (p = this.parent.compareTo(o.getParent())) != 0) {
                return p;
            }
            if (this.index < o.getIndex()) {
                return -1;
            }
            if (this.index > o.getIndex()) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Tree.Key) {
                Tree.Key ok = (Tree.Key)obj;
                if (this.level != ok.getLevel()) {
                    return false;
                }
                if (this.level != 0 && !this.parent.equals(ok.getParent())) {
                    return false;
                }
                return this.index == ok.getIndex();
            }
            return false;
        }

        public int hashCode() {
            if (this.hash == 0) {
                this.hash = this.parent != null ? this.parent.hashCode() * 31 + this.index : 31 + this.index;
            }
            return this.hash;
        }

        public String toString() {
            if (this.string == null) {
                this.string = this.parent != null ? this.parent.toString() + "," + this.index : Integer.toString(this.index);
            }
            return this.string;
        }
    }
}

