/*
 * Decompiled with CFR 0.152.
 */
package net.matrix.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.matrix.io.RelativeResource;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class RelativeResourceRootRegister {
    private static final Logger LOG = LoggerFactory.getLogger(RelativeResourceRootRegister.class);
    private Map<String, Resource> roots = new HashMap<String, Resource>();

    public void registerRoot(String name, Resource root) {
        this.roots.put(name, root);
    }

    public Resource getRoot(String name) {
        return this.roots.get(name);
    }

    public Resource getResource(RelativeResource relativeResource) throws IOException {
        Resource root = this.getRoot(relativeResource.getRoot());
        if (root == null) {
            throw new IllegalStateException("\u6839\u8def\u5f84 " + relativeResource.getRoot() + " \u672a\u6ce8\u518c");
        }
        return root.createRelative(relativeResource.getPath());
    }

    public File getNewFile(RelativeResource relativeFile) throws IOException {
        File file = this.getResource(relativeFile).getFile();
        if (file.exists()) {
            LOG.debug("\u5220\u9664\u65e7\u6587\u4ef6\uff1a" + file);
            boolean success = file.delete();
            if (!success) {
                LOG.warn("\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff1a" + file);
            }
        }
        return file;
    }

    public void moveFile(RelativeResource src, RelativeResource dest) throws IOException {
        boolean success;
        if (src.equals(dest)) {
            return;
        }
        LOG.debug("\u642c\u79fb\u6587\u4ef6\u4ece  " + src + " \u5230 " + dest);
        File srcFile = this.getResource(src).getFile();
        File destFile = this.getResource(dest).getFile();
        if (!srcFile.exists()) {
            throw new FileNotFoundException(srcFile.getAbsolutePath());
        }
        if (destFile.exists() && !(success = destFile.delete())) {
            LOG.warn("\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff1a" + destFile);
        }
        FileUtils.moveFile((File)srcFile, (File)destFile);
    }

    public void copyFile(RelativeResource src, RelativeResource dest) throws IOException {
        boolean success;
        if (src.equals(dest)) {
            return;
        }
        LOG.debug("\u590d\u5236\u6587\u4ef6\u4ece  " + src + " \u5230 " + dest);
        File srcFile = this.getResource(src).getFile();
        File destFile = this.getResource(dest).getFile();
        if (!srcFile.exists()) {
            throw new FileNotFoundException(srcFile.getAbsolutePath());
        }
        if (destFile.exists() && !(success = destFile.delete())) {
            LOG.warn("\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff1a" + destFile);
        }
        FileUtils.copyFile((File)srcFile, (File)destFile);
    }
}

