/*
 * Decompiled with CFR 0.152.
 */
package net.matrix.lang;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import net.matrix.lang.ImpossibleException;
import net.matrix.lang.ReflectionRuntimeException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Reflections {
    private static final Logger LOG = LoggerFactory.getLogger(Reflections.class);
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";

    private Reflections() {
    }

    public static <T> T invokeGetter(Object target, String name) {
        String getterMethodName = GETTER_PREFIX + StringUtils.capitalize((String)name);
        return Reflections.invokeMethod(target, getterMethodName, new Class[0], new Object[0]);
    }

    public static void invokeSetter(Object target, String name, Object value) {
        String setterMethodName = SETTER_PREFIX + StringUtils.capitalize((String)name);
        Reflections.invokeMethodByName(target, setterMethodName, new Object[]{value});
    }

    public static <T> T getFieldValue(Object target, String name) {
        Field field = FieldUtils.getDeclaredField(target.getClass(), (String)name, (boolean)true);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + name + "] on target [" + target + "]");
        }
        Object result = null;
        try {
            result = field.get(target);
        }
        catch (IllegalAccessException e) {
            throw new ImpossibleException(e);
        }
        return (T)result;
    }

    public static void setFieldValue(Object target, String name, Object value) {
        Field field = FieldUtils.getDeclaredField(target.getClass(), (String)name, (boolean)true);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + name + "] on target [" + target + "]");
        }
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new ImpossibleException(e);
        }
    }

    public static <T> T invokeMethod(Object target, String name, Class<?>[] parameterTypes, Object[] parameterValues) {
        Method method = Reflections.getAccessibleMethod(target, name, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + name + "] on target [" + target + "]");
        }
        try {
            return (T)method.invoke(target, parameterValues);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionRuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionRuntimeException(e);
        }
    }

    public static <T> T invokeMethodByName(Object target, String name, Object[] parameterValues) {
        Method method = Reflections.getAccessibleMethodByName(target, name);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + name + "] on target [" + target + "]");
        }
        try {
            return (T)method.invoke(target, parameterValues);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionRuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionRuntimeException(e);
        }
    }

    public static Field getAccessibleField(Object target, String name) {
        for (Class<?> superClass = target.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(name);
                Reflections.makeAccessible(field);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethod(Object target, String name, Class<?> ... parameterTypes) {
        for (Class<?> searchType = target.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            try {
                Method method = searchType.getDeclaredMethod(name, parameterTypes);
                Reflections.makeAccessible(method);
                return method;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethodByName(Object target, String name) {
        for (Class<?> searchType = target.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(name)) continue;
                Reflections.makeAccessible(method);
                return method;
            }
        }
        return null;
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static <T> Class<T> getClassGenricType(Class clazz) {
        return Reflections.getClassGenricType(clazz, 0);
    }

    public static Class getClassGenricType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            LOG.warn(clazz.getSimpleName() + "'s superclass not ParameterizedType");
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            LOG.warn("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length);
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            LOG.warn(clazz.getSimpleName() + " not set the actual class on superclass generic parameter");
            return Object.class;
        }
        return (Class)params[index];
    }
}

