/*
 * Decompiled with CFR 0.152.
 */
package net.matrix.security;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import net.matrix.lang.ImpossibleException;

public final class Digests {
    private static final String SHA1 = "SHA-1";
    private static final String MD5 = "MD5";
    private static final SecureRandom RANDOM = new SecureRandom();

    private Digests() {
    }

    public static byte[] sha1(byte[] input) {
        return Digests.digest(input, SHA1, null, 1);
    }

    public static byte[] sha1(byte[] input, byte[] salt) {
        return Digests.digest(input, SHA1, salt, 1);
    }

    public static byte[] sha1(byte[] input, byte[] salt, int iterations) {
        return Digests.digest(input, SHA1, salt, iterations);
    }

    private static byte[] digest(byte[] input, String algorithm, byte[] salt, int iterations) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            if (salt != null) {
                digest.update(salt);
            }
            byte[] result = digest.digest(input);
            for (int i = 1; i < iterations; ++i) {
                digest.reset();
                result = digest.digest(result);
            }
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new ImpossibleException(e);
        }
    }

    public static byte[] generateSalt(int numBytes) {
        byte[] bytes = new byte[numBytes];
        RANDOM.nextBytes(bytes);
        return bytes;
    }

    public static byte[] md5(InputStream input) throws IOException {
        return Digests.digest(input, MD5);
    }

    public static byte[] sha1(InputStream input) throws IOException {
        return Digests.digest(input, SHA1);
    }

    private static byte[] digest(InputStream input, String algorithm) throws IOException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            int bufferLength = 8192;
            byte[] buffer = new byte[8192];
            int read = input.read(buffer, 0, 8192);
            while (read > -1) {
                messageDigest.update(buffer, 0, read);
                read = input.read(buffer, 0, 8192);
            }
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ImpossibleException(e);
        }
    }
}

