/*
 * Decompiled with CFR 0.152.
 */
package net.matrix.text;

import java.util.Calendar;
import java.util.Date;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class DateFormatHelper {
    private DateFormatHelper() {
    }

    public static String format(Calendar date, String format) {
        return DateFormatHelper.format(date.getTime(), format);
    }

    public static String format(Date date, String format) {
        return DateFormatHelper.format(date.getTime(), format);
    }

    public static String format(long time, String format) {
        return DateFormatHelper.format(time, DateTimeFormat.forPattern((String)format));
    }

    public static String format(long time, DateTimeFormatter format) {
        return format.print(time);
    }

    public static Calendar parse(String date, String format) {
        return DateFormatHelper.parse(date, DateTimeFormat.forPattern((String)format));
    }

    public static Calendar parse(String date, DateTimeFormatter format) {
        return format.parseDateTime(date).toGregorianCalendar();
    }

    public static Calendar parse(String date) {
        return DateFormatHelper.parse(date, ISODateTimeFormat.dateHourMinuteSecond());
    }

    public static String toString(Calendar date) {
        return DateFormatHelper.format(date.getTimeInMillis(), ISODateTimeFormat.dateHourMinuteSecond());
    }

    public static String toDisplayString(Calendar date) {
        return DateFormatHelper.format(date.getTimeInMillis(), ISODateTimeFormat.yearMonthDay());
    }

    public static String toDisplayString(Calendar date, String year, String month, String day) {
        return DateFormatHelper.format(date, "yyyy") + year + DateFormatHelper.format(date, "MM") + month + DateFormatHelper.format(date, "dd") + day;
    }

    public static String toChineseString(Calendar date) {
        return DateFormatHelper.toDisplayString(date, "\u5e74", "\u6708", "\u65e5");
    }
}

