/*
 * Decompiled with CFR 0.152.
 */
package net.matrix.text;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import net.matrix.text.Resources;

public final class MessageFormats {
    private MessageFormats() {
    }

    public static String formatFallback(String pattern, Object ... arguments) {
        StringBuilder sb = new StringBuilder(pattern);
        for (Object argument : arguments) {
            sb.append(", ");
            sb.append(argument);
        }
        return sb.toString();
    }

    public static String format(String pattern, Locale locale, Object ... arguments) {
        MessageFormat format = new MessageFormat(pattern, locale);
        return format.format(arguments);
    }

    public static String format(ResourceBundle bundle, String key, Object ... arguments) {
        String pattern = Resources.getProperty(bundle, key);
        if (arguments.length == 0) {
            return pattern;
        }
        if (pattern.equals(key)) {
            return MessageFormats.formatFallback(pattern, arguments);
        }
        return MessageFormats.format(pattern, bundle.getLocale(), arguments);
    }
}

