/*
 * Decompiled with CFR 0.152.
 */
package net.matrix.text;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import net.matrix.text.Locales;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Resources {
    private static final Logger LOG = LoggerFactory.getLogger(Resources.class);
    private static final ResourceBundle FALLBACK_BUNDLE = new ResourceBundle(){

        @Override
        protected Object handleGetObject(String key) {
            return key;
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.emptyEnumeration();
        }
    };
    private static final ResourceBundle.Control XML_BUNDLE_CONTROL = new XMLResourceBundleControl();

    private Resources() {
    }

    public static ResourceBundle getBundle(String baseName) {
        return Resources.getBundle(baseName, Locales.current());
    }

    public static ResourceBundle getBundle(String baseName, Locale locale) {
        try {
            return ResourceBundle.getBundle(baseName, locale, XML_BUNDLE_CONTROL);
        }
        catch (MissingResourceException e) {
            LOG.warn(baseName + " \u8d44\u6e90\u52a0\u8f7d\u5931\u8d25", (Throwable)e);
            return FALLBACK_BUNDLE;
        }
    }

    public static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader) {
        try {
            return ResourceBundle.getBundle(baseName, locale, loader, XML_BUNDLE_CONTROL);
        }
        catch (MissingResourceException e) {
            LOG.warn(baseName + " \u8d44\u6e90\u52a0\u8f7d\u5931\u8d25", (Throwable)e);
            return FALLBACK_BUNDLE;
        }
    }

    public static String getProperty(ResourceBundle bundle, String key) {
        if (bundle == null) {
            return key;
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            LOG.warn("\u627e\u4e0d\u5230\u540d\u4e3a " + key + " \u7684\u8d44\u6e90\u9879", (Throwable)e);
            return key;
        }
    }

    private static final class XMLResourceBundle
    extends ResourceBundle {
        private Properties props = new Properties();

        private XMLResourceBundle(InputStream stream) throws IOException {
            this.props.loadFromXML(stream);
        }

        @Override
        protected Object handleGetObject(String key) {
            return this.props.getProperty(key);
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.enumeration(this.props.stringPropertyNames());
        }
    }

    private static class XMLResourceBundleControl
    extends ResourceBundle.Control {
        private static final List<String> FORMATS = Arrays.asList("xml");

        private XMLResourceBundleControl() {
        }

        @Override
        public List<String> getFormats(String baseName) {
            if (baseName == null) {
                throw new NullPointerException("baseName");
            }
            return FORMATS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            if (baseName == null || locale == null || format == null || loader == null) {
                throw new NullPointerException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            XMLResourceBundle bundle = null;
            if (format.equals("xml")) {
                String bundleName = this.toBundleName(baseName, locale);
                String resourceName = this.toResourceName(bundleName, format);
                InputStream stream = null;
                if (reload) {
                    URLConnection connection;
                    URL url = loader.getResource(resourceName);
                    if (url != null && (connection = url.openConnection()) != null) {
                        connection.setUseCaches(false);
                        stream = connection.getInputStream();
                    }
                } else {
                    stream = loader.getResourceAsStream(resourceName);
                }
                if (stream != null) {
                    BufferedInputStream bis = new BufferedInputStream(stream);
                    try {
                        bundle = new XMLResourceBundle(bis);
                    }
                    finally {
                        bis.close();
                    }
                }
            }
            return bundle;
        }
    }
}

