/*
 * Decompiled with CFR 0.152.
 */
package net.matrix.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import net.matrix.lang.ImpossibleException;
import org.apache.commons.lang3.Validate;

public final class Encodes {
    private static final String BASE62 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String DEFAULT_URL_ENCODING = "UTF-8";

    private Encodes() {
    }

    public static String encodeBase62(long num) {
        int base = BASE62.length();
        StringBuilder sb = new StringBuilder();
        for (long index = Math.abs(num); index > 0L; index /= (long)base) {
            sb.append(BASE62.charAt((int)(index % (long)base)));
        }
        return sb.toString();
    }

    public static long decodeBase62(String str) {
        Validate.notBlank((CharSequence)str);
        long result = 0L;
        int base = BASE62.length();
        for (int i = 0; i < str.length(); ++i) {
            result = (long)((double)result + (double)BASE62.indexOf(str.charAt(i)) * Math.pow(base, i));
        }
        return result;
    }

    public static String urlEncode(String part) {
        try {
            return URLEncoder.encode(part, DEFAULT_URL_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new ImpossibleException(e);
        }
    }

    public static String urlDecode(String part) {
        try {
            return URLDecoder.decode(part, DEFAULT_URL_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new ImpossibleException(e);
        }
    }
}

