/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.runner;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.runner.JUnitPlatformRunnerListener;
import org.junit.platform.runner.JUnitPlatformTestTree;
import org.junit.platform.suite.commons.SuiteLauncherDiscoveryRequestBuilder;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;

public class JUnit5Runner
extends Runner
implements Filterable {
    private final Class<?> testClass;
    private final Launcher launcher;
    private JUnitPlatformTestTree testTree;

    public JUnit5Runner(Class<?> testClass) {
        this.testClass = testClass;
        this.launcher = LauncherFactory.create();
        this.testTree = this.generateTestTree(this.createDiscoveryRequest());
    }

    public Description getDescription() {
        return this.testTree.getSuiteDescription();
    }

    public void run(RunNotifier notifier) {
        this.launcher.execute(this.testTree.getTestPlan(), new TestExecutionListener[]{new JUnitPlatformRunnerListener(this.testTree, notifier)});
    }

    private JUnitPlatformTestTree generateTestTree(LauncherDiscoveryRequest discoveryRequest) {
        TestPlan testPlan = this.launcher.discover(discoveryRequest);
        return new JUnitPlatformTestTree(testPlan, this.testClass);
    }

    private LauncherDiscoveryRequest createDiscoveryRequest() {
        SuiteLauncherDiscoveryRequestBuilder requestBuilder = SuiteLauncherDiscoveryRequestBuilder.request();
        requestBuilder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(this.testClass)});
        requestBuilder.applyConfigurationParametersFromSuite(this.testClass).applySelectorsAndFiltersFromSuite(this.testClass);
        return requestBuilder.build();
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        Set filteredIdentifiers = this.testTree.getFilteredLeaves(filter);
        if (filteredIdentifiers.isEmpty()) {
            throw new NoTestsRemainException();
        }
        this.testTree = this.generateTestTree(this.createDiscoveryRequestForUniqueIds(filteredIdentifiers));
    }

    private LauncherDiscoveryRequest createDiscoveryRequestForUniqueIds(Set<TestIdentifier> testIdentifiers) {
        List selectors = testIdentifiers.stream().map(TestIdentifier::getUniqueIdObject).map(DiscoverySelectors::selectUniqueId).collect(Collectors.toList());
        return SuiteLauncherDiscoveryRequestBuilder.request().selectors(selectors).build();
    }
}

