/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.batchconfig;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.okapi.applications.rainbow.Input;
import net.sf.okapi.applications.rainbow.batchconfig.BatchConfiguration;
import net.sf.okapi.applications.rainbow.pipeline.PipelineStorage;
import net.sf.okapi.applications.rainbow.pipeline.PipelineWrapper;
import net.sf.okapi.common.ExecutionContext;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.DefaultFilters;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipeline;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.plugins.PluginsManager;
import net.sf.okapi.steps.segmentation.Parameters;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BatchConfigurationTest {
    private static final String OKF_CUSTOM_HTML = "okf_custom_html";
    private static final String OKF_CUSTOM_XML = "okf_custom_xml";
    private static final String OKF_OPENXML = "okf_openxml";
    private static final String OKF_PO = "okf_po";
    private static final String OKF_XLIFF = "okf_xliff";
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private static FilterConfigurationMapper fcMapper;
    private static FileLocation root;

    @BeforeClass
    public static void setup() throws Exception {
        root = FileLocation.fromClass(BatchConfigurationTest.class);
        fcMapper = new FilterConfigurationMapper();
        DefaultFilters.setMappings((IFilterConfigurationMapper)fcMapper, (boolean)false, (boolean)true);
    }

    @Test
    public void testExtensionMappings() throws Exception {
        String s;
        File tmpFolder = this.folder.newFolder("temp");
        PluginsManager pm = new PluginsManager();
        pm.discover(tmpFolder, false);
        PipelineWrapper wrapper = new PipelineWrapper((IFilterConfigurationMapper)fcMapper, "", pm, "", "", "", null, new ExecutionContext());
        wrapper.load(root.in("/bconfTest.pln").toString());
        Assert.assertFalse((boolean)((net.sf.okapi.steps.rainbowkit.creation.Parameters)((IPipelineStep)wrapper.getPipeline().getSteps().get(3)).getParameters()).getCreateZip());
        Input html = new Input();
        html.relativePath = "test.html";
        html.filterConfigId = OKF_CUSTOM_HTML;
        Input empty = new Input();
        empty.relativePath = "test";
        empty.filterConfigId = OKF_CUSTOM_XML;
        ArrayList<Input> inputFiles = new ArrayList<Input>();
        inputFiles.add(html);
        inputFiles.add(empty);
        File batchConfigFile = new File(tmpFolder, "exported.bconf");
        BatchConfiguration bc = new BatchConfiguration();
        bc.exportConfiguration(batchConfigFile.getAbsolutePath(), wrapper, (IFilterConfigurationMapper)fcMapper, inputFiles);
        Assert.assertTrue((boolean)batchConfigFile.exists());
        HashMap<String, String> stepParamOverrides = new HashMap<String, String>();
        stepParamOverrides.put("net.sf.okapi.steps.rainbowkit.creation.ExtractionStep", "#v1\ncreateZip.b=true");
        HashMap<String, BatchConfiguration.FilterConfigOverride> filterOverrides = new HashMap<String, BatchConfiguration.FilterConfigOverride>();
        filterOverrides.put(".xml", new BatchConfiguration.FilterConfigOverride("okf_xmlstream-dita", null));
        filterOverrides.put(".foo", new BatchConfiguration.FilterConfigOverride("okf_test", "#v1\nfoo.b=true"));
        bc.installConfiguration(batchConfigFile.getAbsolutePath(), tmpFolder.getAbsolutePath(), wrapper, stepParamOverrides, filterOverrides);
        BufferedReader fh = new BufferedReader(new FileReader(new File(tmpFolder, "extensions-mapping.txt")));
        HashMap<String, String> filterConfigByExtension = new HashMap<String, String>();
        while ((s = fh.readLine()) != null) {
            String[] fields = s.split("\t");
            String ext = fields[0];
            String fc = fields[1];
            filterConfigByExtension.put(ext, fc);
        }
        fh.close();
        Assert.assertTrue((boolean)OKF_CUSTOM_HTML.equals(filterConfigByExtension.get(".html")));
        Assert.assertTrue((boolean)OKF_CUSTOM_XML.equals(filterConfigByExtension.get("")));
        Assert.assertTrue((boolean)OKF_PO.equals(filterConfigByExtension.get(".po")));
        Assert.assertTrue((OKF_OPENXML.equals(filterConfigByExtension.get(".docx")) && OKF_OPENXML.equals(filterConfigByExtension.get(".docm")) && OKF_OPENXML.equals(filterConfigByExtension.get(".pptx")) && OKF_OPENXML.equals(filterConfigByExtension.get(".pptm")) && OKF_OPENXML.equals(filterConfigByExtension.get(".ppsx")) && OKF_OPENXML.equals(filterConfigByExtension.get(".ppsm")) && OKF_OPENXML.equals(filterConfigByExtension.get(".potx")) && OKF_OPENXML.equals(filterConfigByExtension.get(".potm")) && OKF_OPENXML.equals(filterConfigByExtension.get(".xlsx")) && OKF_OPENXML.equals(filterConfigByExtension.get(".xlsm")) && OKF_OPENXML.equals(filterConfigByExtension.get(".xltx")) && OKF_OPENXML.equals(filterConfigByExtension.get(".xltm")) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)OKF_OPENXML.equals(filterConfigByExtension.get(".vsdx")));
        Assert.assertTrue((boolean)OKF_XLIFF.equals(filterConfigByExtension.get(".mxliff")));
        Assert.assertEquals((Object)"okf_xmlstream-dita", filterConfigByExtension.get(".xml"));
        Assert.assertEquals((Object)"okf_test@custom_1", filterConfigByExtension.get(".foo"));
        String okfTestContent = new String(Files.readAllBytes(Paths.get(tmpFolder.toString(), "okf_test@custom_1.fprm")), StandardCharsets.UTF_8);
        Assert.assertEquals((Object)"#v1\nfoo.b=true", (Object)okfTestContent);
        PipelineStorage pipelineStore = new PipelineStorage(wrapper.getAvailableSteps(), new File(tmpFolder, "pipeline.pln").getAbsolutePath());
        IPipeline pipeline = pipelineStore.read();
        List steps = pipeline.getSteps();
        Assert.assertEquals((long)4L, (long)steps.size());
        Assert.assertEquals((Object)"net.sf.okapi.steps.xsltransform.XSLTransformStep", (Object)((IPipelineStep)steps.get(0)).getClass().getName());
        net.sf.okapi.steps.xsltransform.Parameters xslStepParams = (net.sf.okapi.steps.xsltransform.Parameters)((IPipelineStep)steps.get(0)).getParameters();
        Assert.assertEquals((Object)"copySourceToTarget.xslt", (Object)new File(xslStepParams.getXsltPath()).getName());
        Assert.assertEquals((Object)"net.sf.okapi.steps.common.RawDocumentToFilterEventsStep", (Object)((IPipelineStep)steps.get(1)).getClass().getName());
        Assert.assertEquals((Object)"net.sf.okapi.steps.segmentation.SegmentationStep", (Object)((IPipelineStep)steps.get(2)).getClass().getName());
        Parameters segStepParams = (Parameters)((IPipelineStep)steps.get(2)).getParameters();
        Assert.assertEquals((Object)"SourceSRXRules.srx", (Object)new File(segStepParams.getSourceSrxPath()).getName());
        Assert.assertEquals((Object)"TargetSRXRules.srx", (Object)new File(segStepParams.getTargetSrxPath()).getName());
        Assert.assertEquals((Object)"net.sf.okapi.steps.rainbowkit.creation.ExtractionStep", (Object)((IPipelineStep)steps.get(3)).getClass().getName());
        net.sf.okapi.steps.rainbowkit.creation.Parameters p = (net.sf.okapi.steps.rainbowkit.creation.Parameters)((IPipelineStep)steps.get(3)).getParameters();
        Assert.assertTrue((boolean)p.getCreateZip());
    }

    @Test
    public void testExtensionMappingsWithWildcardStepParamOverrides() throws Exception {
        File tmpFolder = this.folder.newFolder("temp");
        PluginsManager pm = new PluginsManager();
        pm.discover(tmpFolder, false);
        PipelineWrapper wrapper = new PipelineWrapper((IFilterConfigurationMapper)fcMapper, "", pm, "", "", "", null, new ExecutionContext());
        wrapper.load(root.in("/bconfTest.pln").toString());
        Assert.assertFalse((boolean)((net.sf.okapi.steps.rainbowkit.creation.Parameters)((IPipelineStep)wrapper.getPipeline().getSteps().get(3)).getParameters()).getCreateZip());
        Input html = new Input();
        html.relativePath = "test.html";
        html.filterConfigId = OKF_CUSTOM_HTML;
        Input empty = new Input();
        empty.relativePath = "test";
        empty.filterConfigId = OKF_CUSTOM_XML;
        ArrayList<Input> inputFiles = new ArrayList<Input>();
        inputFiles.add(html);
        inputFiles.add(empty);
        File batchConfigFile = new File(tmpFolder, "exported.bconf");
        BatchConfiguration bc = new BatchConfiguration();
        bc.exportConfiguration(batchConfigFile.getAbsolutePath(), wrapper, (IFilterConfigurationMapper)fcMapper, inputFiles);
        Assert.assertTrue((boolean)batchConfigFile.exists());
        HashMap<String, BatchConfiguration.FilterConfigOverride> filterOverrides = new HashMap<String, BatchConfiguration.FilterConfigOverride>();
        filterOverrides.put(".xml", new BatchConfiguration.FilterConfigOverride("okf_xmlstream-dita", null));
        filterOverrides.put(".foo", new BatchConfiguration.FilterConfigOverride("okf_test", "#v1\nfoo.b=true"));
        HashMap<String, String> stepParamOverrides = new HashMap<String, String>();
        stepParamOverrides.put("net.sf.okapi.steps.rainbowkit.creation.Extraction*", "#v1\ncreateZip.b=true");
        bc.installConfiguration(batchConfigFile.getAbsolutePath(), tmpFolder.getAbsolutePath(), wrapper, stepParamOverrides, filterOverrides);
        PipelineStorage pipelineStore = new PipelineStorage(wrapper.getAvailableSteps(), new File(tmpFolder, "pipeline.pln").getAbsolutePath());
        IPipeline pipeline = pipelineStore.read();
        List steps = pipeline.getSteps();
        Assert.assertEquals((long)4L, (long)steps.size());
        Assert.assertEquals((Object)"net.sf.okapi.steps.rainbowkit.creation.ExtractionStep", (Object)((IPipelineStep)steps.get(3)).getClass().getName());
        net.sf.okapi.steps.rainbowkit.creation.Parameters p = (net.sf.okapi.steps.rainbowkit.creation.Parameters)((IPipelineStep)steps.get(3)).getParameters();
        Assert.assertTrue((boolean)p.getCreateZip());
    }

    @Test
    public void testExtensionMappingsWithNamedAndWildcardStepParamOverrides() throws Exception {
        File tmpFolder = this.folder.newFolder("temp");
        PluginsManager pm = new PluginsManager();
        pm.discover(tmpFolder, false);
        PipelineWrapper wrapper = new PipelineWrapper((IFilterConfigurationMapper)fcMapper, "", pm, "", "", "", null, new ExecutionContext());
        wrapper.load(root.in("/bconfTest.pln").toString());
        Assert.assertFalse((boolean)((net.sf.okapi.steps.rainbowkit.creation.Parameters)((IPipelineStep)wrapper.getPipeline().getSteps().get(3)).getParameters()).getCreateZip());
        Assert.assertEquals((Object)"", (Object)((net.sf.okapi.steps.rainbowkit.creation.Parameters)((IPipelineStep)wrapper.getPipeline().getSteps().get(3)).getParameters()).getMessage());
        Input html = new Input();
        html.relativePath = "test.html";
        html.filterConfigId = OKF_CUSTOM_HTML;
        Input empty = new Input();
        empty.relativePath = "test";
        empty.filterConfigId = OKF_CUSTOM_XML;
        ArrayList<Input> inputFiles = new ArrayList<Input>();
        inputFiles.add(html);
        inputFiles.add(empty);
        File batchConfigFile = new File(tmpFolder, "exported.bconf");
        BatchConfiguration bc = new BatchConfiguration();
        bc.exportConfiguration(batchConfigFile.getAbsolutePath(), wrapper, (IFilterConfigurationMapper)fcMapper, inputFiles);
        Assert.assertTrue((boolean)batchConfigFile.exists());
        HashMap<String, BatchConfiguration.FilterConfigOverride> filterOverrides = new HashMap<String, BatchConfiguration.FilterConfigOverride>();
        filterOverrides.put(".xml", new BatchConfiguration.FilterConfigOverride("okf_xmlstream-dita", null));
        filterOverrides.put(".foo", new BatchConfiguration.FilterConfigOverride("okf_test", "#v1\nfoo.b=true"));
        HashMap<String, String> stepParamOverrides = new HashMap<String, String>();
        stepParamOverrides.put("net.sf.okapi.steps.rainbowkit.creation.ExtractionStep", "#v1\ncreateZip.b=true");
        stepParamOverrides.put("net.sf.okapi.steps.rainbowkit.creation.*", "#v1\nmessage=Hello World");
        bc.installConfiguration(batchConfigFile.getAbsolutePath(), tmpFolder.getAbsolutePath(), wrapper, stepParamOverrides, filterOverrides);
        PipelineStorage pipelineStore = new PipelineStorage(wrapper.getAvailableSteps(), new File(tmpFolder, "pipeline.pln").getAbsolutePath());
        IPipeline pipeline = pipelineStore.read();
        List steps = pipeline.getSteps();
        Assert.assertEquals((long)4L, (long)steps.size());
        Assert.assertEquals((Object)"net.sf.okapi.steps.rainbowkit.creation.ExtractionStep", (Object)((IPipelineStep)steps.get(3)).getClass().getName());
        net.sf.okapi.steps.rainbowkit.creation.Parameters p = (net.sf.okapi.steps.rainbowkit.creation.Parameters)((IPipelineStep)steps.get(3)).getParameters();
        Assert.assertTrue((boolean)p.getCreateZip());
        Assert.assertEquals((Object)"Hello World", (Object)p.getMessage());
    }

    @Test
    public void testExtensionMappingsDuplicateStepParamOverrides() throws Exception {
        File tmpFolder = this.folder.newFolder("temp");
        PluginsManager pm = new PluginsManager();
        pm.discover(tmpFolder, false);
        PipelineWrapper wrapper = new PipelineWrapper((IFilterConfigurationMapper)fcMapper, "", pm, "", "", "", null, new ExecutionContext());
        wrapper.load(root.in("/bconfTest.pln").toString());
        Assert.assertFalse((boolean)((net.sf.okapi.steps.rainbowkit.creation.Parameters)((IPipelineStep)wrapper.getPipeline().getSteps().get(3)).getParameters()).getCreateZip());
        Assert.assertEquals((Object)"", (Object)((net.sf.okapi.steps.rainbowkit.creation.Parameters)((IPipelineStep)wrapper.getPipeline().getSteps().get(3)).getParameters()).getMessage());
        Input html = new Input();
        html.relativePath = "test.html";
        html.filterConfigId = OKF_CUSTOM_HTML;
        Input empty = new Input();
        empty.relativePath = "test";
        empty.filterConfigId = OKF_CUSTOM_XML;
        ArrayList<Input> inputFiles = new ArrayList<Input>();
        inputFiles.add(html);
        inputFiles.add(empty);
        File batchConfigFile = new File(tmpFolder, "exported.bconf");
        BatchConfiguration bc = new BatchConfiguration();
        bc.exportConfiguration(batchConfigFile.getAbsolutePath(), wrapper, (IFilterConfigurationMapper)fcMapper, inputFiles);
        Assert.assertTrue((boolean)batchConfigFile.exists());
        HashMap<String, BatchConfiguration.FilterConfigOverride> filterOverrides = new HashMap<String, BatchConfiguration.FilterConfigOverride>();
        filterOverrides.put(".xml", new BatchConfiguration.FilterConfigOverride("okf_xmlstream-dita", null));
        filterOverrides.put(".foo", new BatchConfiguration.FilterConfigOverride("okf_test", "#v1\nfoo.b=true"));
        HashMap<String, String> stepParamOverrides = new HashMap<String, String>();
        stepParamOverrides.put("net.sf.okapi.steps.rainbowkit.creation.ExtractionStep", "#v1\nmessage=Bonjour Monde\n\n");
        stepParamOverrides.put("net.sf.okapi.steps.rainbowkit.creation.*", "#v1\nmessage=Hello World\n\n");
        try {
            bc.installConfiguration(batchConfigFile.getAbsolutePath(), tmpFolder.getAbsolutePath(), wrapper, stepParamOverrides, filterOverrides);
        }
        catch (OkapiIOException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("Duplicate parameters [message] proposed to be set on class net.sf.okapi.steps.rainbowkit.creation.ExtractionStep"));
        }
    }
}

