/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.lib;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.okapi.applications.rainbow.lib.EncodingItem;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EncodingManager {
    private ArrayList<EncodingItem> items = new ArrayList();

    public int getCount() {
        return this.items.size();
    }

    public EncodingItem getItem(int index) {
        return this.items.get(index);
    }

    public int getIndexFromIANAName(String ianaName) {
        int i = 0;
        for (EncodingItem item : this.items) {
            if (ianaName.equalsIgnoreCase(item.ianaName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void loadList(InputStream is) {
        try {
            DocumentBuilderFactory Fact = DocumentBuilderFactory.newInstance();
            Fact.setValidating(false);
            this.parseDoc(Fact.newDocumentBuilder().parse(is));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new OkapiException((Throwable)e);
        }
    }

    public void loadList(String p_sPath) {
        try {
            DocumentBuilderFactory Fact = DocumentBuilderFactory.newInstance();
            Fact.setValidating(false);
            this.parseDoc(Fact.newDocumentBuilder().parse(new File(p_sPath)));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new OkapiException((Throwable)e);
        }
    }

    public void parseDoc(Document doc) {
        NodeList NL = doc.getElementsByTagName("encoding");
        this.items.clear();
        for (int i = 0; i < NL.getLength(); ++i) {
            Node N = NL.item(i).getAttributes().getNamedItem("iana");
            if (N == null) {
                throw new OkapiException("The attribute 'iana' is missing.");
            }
            EncodingItem item = new EncodingItem();
            item.ianaName = Util.getTextContent((Node)N);
            N = NL.item(i).getAttributes().getNamedItem("cp");
            item.codePage = N == null ? -1 : Integer.valueOf(Util.getTextContent((Node)N));
            for (N = NL.item(i).getFirstChild(); N != null; N = N.getNextSibling()) {
                if (N.getNodeType() != 1 || !N.getNodeName().equals("name")) continue;
                item.name = Util.getTextContent((Node)N);
                break;
            }
            if (item.name == null) {
                throw new OkapiException("The element 'name' is missing.");
            }
            this.items.add(item);
        }
    }
}

