/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.lib;

import java.util.List;
import net.sf.okapi.applications.rainbow.lib.FilterConfigInfoEditor;
import net.sf.okapi.applications.rainbow.lib.Res;
import net.sf.okapi.common.BaseContext;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.FilterInfo;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.common.ui.filters.FilterConfigurationEditor;
import net.sf.okapi.common.ui.filters.FilterConfigurationsDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FilterConfigSelectionPanel
extends Composite {
    private FilterConfigurationMapper mapper;
    private Combo cbFilters;
    private Text edDescription;
    private org.eclipse.swt.widgets.List lbConfigs;
    private Button btEdit;
    private Button btCreate;
    private Button btDelete;
    private Button btMore;
    private BaseContext context = new BaseContext();
    private List<FilterInfo> filters;
    private IFilter cachedFilter;
    private IHelp help;

    public FilterConfigSelectionPanel(Composite p_Parent, IHelp helpParam, int p_nFlags, FilterConfigurationMapper mapper, String projectDir) {
        super(p_Parent, 0);
        this.help = helpParam;
        this.context.setObject("help", (Object)helpParam);
        this.context.setString("projDir", projectDir);
        this.context.setObject("shell", (Object)this.getShell());
        this.mapper = mapper;
        this.createContent();
    }

    private void createContent() {
        GridLayout layTmp = new GridLayout(4, false);
        layTmp.marginHeight = 0;
        layTmp.marginWidth = 0;
        this.setLayout((Layout)layTmp);
        this.cbFilters = new Combo((Composite)this, 12);
        GridData gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 4;
        gdTmp.widthHint = 340;
        this.cbFilters.setLayoutData((Object)gdTmp);
        this.cbFilters.setVisibleItemCount(15);
        this.cbFilters.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e1) {
                FilterConfigSelectionPanel.this.fillConfigurations(0, null);
            }

            public void widgetDefaultSelected(SelectionEvent e2) {
            }
        });
        this.lbConfigs = new org.eclipse.swt.widgets.List((Composite)this, 2564);
        gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 4;
        gdTmp.heightHint = 60;
        this.lbConfigs.setLayoutData((Object)gdTmp);
        this.lbConfigs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FilterConfigSelectionPanel.this.updateConfigurationInfo();
            }
        });
        this.lbConfigs.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                FilterConfigSelectionPanel.this.editParameters();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.edDescription = new Text((Composite)this, 2114);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 4;
        gdTmp.heightHint = 60;
        this.edDescription.setLayoutData((Object)gdTmp);
        this.edDescription.setEditable(false);
        int nWidth = 80;
        this.btEdit = new Button((Composite)this, 8);
        this.btEdit.setText(Res.getString("FilterConfigSelectionPanel.edit"));
        this.btEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterConfigSelectionPanel.this.editParameters();
            }
        });
        this.btCreate = new Button((Composite)this, 8);
        this.btCreate.setText(Res.getString("FilterConfigSelectionPanel.create"));
        this.btCreate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterConfigSelectionPanel.this.createConfiguration();
            }
        });
        this.btDelete = new Button((Composite)this, 8);
        this.btDelete.setText(Res.getString("FilterConfigSelectionPanel.delete"));
        this.btDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterConfigSelectionPanel.this.deleteConfiguration();
            }
        });
        this.btMore = new Button((Composite)this, 8);
        this.btMore.setText(Res.getString("FilterConfigSelectionPanel.more"));
        this.btMore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterConfigSelectionPanel.this.editAllConfigurations();
            }
        });
        nWidth = UIUtil.getMinimumWidth((int)nWidth, (Button)this.btEdit, (String)Res.getString("FilterConfigSelectionPanel.view"));
        UIUtil.setSameWidth((int)nWidth, (Control[])new Control[]{this.btEdit, this.btCreate, this.btDelete, this.btMore});
    }

    public String getConfigurationId() {
        int n = this.lbConfigs.getSelectionIndex();
        if (n < 0) {
            return "";
        }
        return this.lbConfigs.getItem(n);
    }

    public void setConfigurationId(String configId) {
        this.cbFilters.removeAll();
        this.cbFilters.add(Res.getString("FilterConfigSelectionPanel.noFilter"));
        this.filters = this.mapper.getFiltersInfo();
        for (FilterInfo item : this.filters) {
            this.cbFilters.add(item.toString());
        }
        FilterConfiguration config = this.mapper.getConfiguration(configId);
        if (config == null && configId != null && configId.length() != 0) {
            Dialogs.showError((Shell)this.getShell(), (String)String.format(Res.getString("FilterConfigSelectionPanel.configNotFound"), configId), null);
        }
        this.setConfiguration(config);
    }

    private void setConfiguration(FilterConfiguration config) {
        int n = -1;
        if (config != null) {
            for (int i = 0; i < this.filters.size(); ++i) {
                if (!this.filters.get((int)i).className.equals(config.filterClass)) continue;
                n = i;
                break;
            }
            if (n == -1) {
                Dialogs.showError((Shell)this.getShell(), (String)String.format(Res.getString("FilterConfigSelectionPanel.configOrFilterNotFound"), config.configId), null);
            }
        }
        this.cbFilters.select(n > -1 ? n + 1 : 0);
        this.fillConfigurations(0, config == null ? null : config.configId);
    }

    private void editAllConfigurations() {
        try {
            int n = this.lbConfigs.getSelectionIndex();
            String configId = null;
            if (n > -1) {
                configId = this.lbConfigs.getItem(n);
            }
            String oldConfigId = configId;
            FilterConfigurationsDialog dlg = new FilterConfigurationsDialog(this.getShell(), true, this.mapper, this.help);
            configId = dlg.showDialog(configId);
            if (configId == null) {
                configId = oldConfigId;
            }
            this.setConfigurationId(configId);
        }
        catch (Throwable e) {
            Dialogs.showError((Shell)this.getShell(), (String)e.getMessage(), null);
        }
    }

    private void updateConfigurationInfo() {
        int n = this.lbConfigs.getSelectionIndex();
        String configId = null;
        if (n > -1) {
            configId = this.lbConfigs.getItem(n);
        }
        if (configId == null || configId.length() == 0) {
            this.edDescription.setText("");
            this.btEdit.setEnabled(false);
            this.btCreate.setEnabled(false);
            this.btDelete.setEnabled(false);
        } else {
            FilterConfiguration config = this.mapper.getConfiguration(configId);
            this.edDescription.setText(config.name + "\n" + config.description);
            if (config.custom) {
                this.btEdit.setText(Res.getString("FilterConfigSelectionPanel.edit"));
            } else {
                this.btEdit.setText(Res.getString("FilterConfigSelectionPanel.view"));
            }
            this.btEdit.setEnabled(true);
            this.btCreate.setEnabled(true);
            this.btDelete.setEnabled(config.custom);
        }
    }

    private void fillConfigurations(int index, String selectedConfigId) {
        if (selectedConfigId != null) {
            index = 0;
        }
        this.lbConfigs.removeAll();
        int n = this.cbFilters.getSelectionIndex();
        if (n < 1) {
            this.updateConfigurationInfo();
            return;
        }
        List list = this.mapper.getFilterConfigurations(this.filters.get((int)(--n)).className);
        int i = 0;
        for (FilterConfiguration item : list) {
            this.lbConfigs.add(item.configId);
            if (selectedConfigId == null) continue;
            if (selectedConfigId.equals(item.configId)) {
                index = i;
            }
            ++i;
        }
        this.lbConfigs.setSelection(index);
        this.updateConfigurationInfo();
    }

    private void editParameters() {
        try {
            String configId = this.getConfigurationId();
            if (configId == null) {
                return;
            }
            FilterConfiguration config = this.mapper.getConfiguration(configId);
            if (config == null) {
                return;
            }
            this.cachedFilter = this.mapper.createFilter(config.configId, this.cachedFilter);
            FilterConfigurationEditor editor = new FilterConfigurationEditor();
            editor.editConfiguration(configId, (IFilterConfigurationMapper)this.mapper, this.cachedFilter, (Object)this.getShell(), (IContext)this.context);
        }
        catch (Throwable e) {
            Dialogs.showError((Shell)this.getShell(), (String)e.getMessage(), null);
        }
    }

    private void createConfiguration() {
        try {
            String baseConfigId = this.getConfigurationId();
            if (baseConfigId == null) {
                return;
            }
            FilterConfiguration baseConfig = this.mapper.getConfiguration(baseConfigId);
            if (baseConfig == null) {
                return;
            }
            FilterConfiguration newConfig = this.mapper.createCustomConfiguration(baseConfig);
            if (newConfig == null) {
                MessageBox dlg = new MessageBox(this.getShell(), 2);
                dlg.setMessage("This filter has no parameters.");
                dlg.setText("Information");
                dlg.open();
                return;
            }
            if (!this.editConfigurationInfo(newConfig)) {
                return;
            }
            IParameters newParams = this.mapper.getParameters(baseConfig);
            this.mapper.saveCustomParameters(newConfig, newParams);
            this.mapper.addConfiguration(newConfig);
            this.fillConfigurations(0, newConfig.configId);
            this.editParameters();
        }
        catch (Throwable e) {
            Dialogs.showError((Shell)this.getShell(), (String)("Error while creating or editing the new configuration. " + e.getMessage()), null);
        }
    }

    private void deleteConfiguration() {
        try {
            String configId = this.getConfigurationId();
            if (configId == null) {
                return;
            }
            FilterConfiguration config = this.mapper.getConfiguration(configId);
            if (!config.custom) {
                return;
            }
            MessageBox dlg = new MessageBox(this.getParent().getShell(), 452);
            dlg.setMessage(String.format(Res.getString("FilterConfigSelectionPanel.confirmDeletion"), configId));
            dlg.setText("Rainbow");
            switch (dlg.open()) {
                case 128: 
                case 256: {
                    return;
                }
            }
            this.mapper.deleteCustomParameters(config);
            this.mapper.removeConfiguration(configId);
            this.fillConfigurations(0, null);
        }
        catch (Throwable e) {
            Dialogs.showError((Shell)this.getShell(), (String)e.getMessage(), null);
        }
    }

    private boolean editConfigurationInfo(FilterConfiguration config) {
        FilterConfigInfoEditor editor = new FilterConfigInfoEditor();
        editor.create(this.getShell());
        return editor.showDialog(config, (IFilterConfigurationMapper)this.mapper);
    }
}

