/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.utilities.extraction;

import net.sf.okapi.applications.rainbow.lib.IAnalysisReporter;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;

class HTMLReporter
implements IAnalysisReporter {
    private XMLWriter writer;
    private int docSegTotal;
    private int docSegExact;
    private int docSegFuzzy;
    private int totalSegTotal;
    private int totalSegExact;
    private int totalSegFuzzy;
    private String docPath;

    HTMLReporter() {
    }

    @Override
    public void create(String path) {
        this.writer = new XMLWriter(path);
        this.writer.writeStartDocument();
        this.writer.writeStartElement("html");
        this.writer.writeStartElement("head");
        this.writer.writeRawXML("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
        this.writer.writeRawXML("<style>td.n {font-family:Courier New; text-align:right; white-space:pre}</style>\n");
        this.writer.writeEndElement();
        this.writer.writeStartElement("body");
        this.writer.writeRawXML("<table cellspacing=\"0\" cellpadding=\"4\" border=\"1\">");
        this.writer.writeElementString("h2", "Translation Package Report");
        this.writer.writeStartElement("tr");
        this.writer.writeRawXML(String.format("<td class=\"h\">%s</td>", "Exact"));
        this.writer.writeRawXML(String.format("<td class=\"h\">%s</td>", "Fuzzy"));
        this.writer.writeRawXML(String.format("<td class=\"h\">%s</td>", "New"));
        this.writer.writeRawXML(String.format("<td class=\"h\">%s</td>", "Total"));
        this.writer.writeRawXML(String.format("<td class=\"h\">%s</td>", "Documents"));
        this.writer.writeEndElement();
    }

    @Override
    public void close() {
        if (this.writer != null) {
            this.writer.writeStartElement("tr");
            this.writer.writeRawXML(String.format("<td class=\"n\">%d (%3d%%)</td>", this.totalSegExact, Util.getPercentage((int)this.totalSegExact, (int)this.totalSegTotal)));
            this.writer.writeRawXML(String.format("<td class=\"n\">%d (%3d%%)</td>", this.totalSegFuzzy, Util.getPercentage((int)this.totalSegFuzzy, (int)this.totalSegTotal)));
            int n = this.totalSegTotal - (this.totalSegExact + this.totalSegFuzzy);
            this.writer.writeRawXML(String.format("<td class=\"n\">%d (%3d%%)</td>", n, Util.getPercentage((int)n, (int)this.totalSegTotal)));
            this.writer.writeRawXML(String.format("<td class=\"n\">%d</td>", this.totalSegTotal));
            this.writer.writeElementString("td", "All Documents");
            this.writer.writeEndElement();
            this.writer.writeRawXML("</table>");
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.writeEndDocument();
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    public void startDocument(String path) {
        this.docPath = path;
        this.docSegFuzzy = 0;
        this.docSegExact = 0;
        this.docSegTotal = 0;
    }

    @Override
    public void endDocument() {
        this.totalSegTotal += this.docSegTotal;
        this.totalSegExact += this.docSegExact;
        this.totalSegFuzzy += this.docSegFuzzy;
        this.writer.writeStartElement("tr");
        this.writer.writeRawXML(String.format("<td class=\"n\">%d (%3d%%)</td>", this.docSegExact, Util.getPercentage((int)this.docSegExact, (int)this.docSegTotal)));
        this.writer.writeRawXML(String.format("<td class=\"n\">%d (%3d%%)</td>", this.docSegFuzzy, Util.getPercentage((int)this.docSegFuzzy, (int)this.docSegTotal)));
        int n = this.docSegTotal - (this.docSegExact + this.docSegFuzzy);
        this.writer.writeRawXML(String.format("<td class=\"n\">%d (%3d%%)</td>", n, Util.getPercentage((int)n, (int)this.docSegTotal)));
        this.writer.writeRawXML(String.format("<td class=\"n\">%d</td>", this.docSegTotal));
        this.writer.writeElementString("td", this.docPath);
        this.writer.writeEndElement();
    }

    @Override
    public void addExactMatch(int value) {
        this.docSegExact += value;
    }

    @Override
    public void addFuzzyMatch(int value) {
        this.docSegFuzzy += value;
    }

    @Override
    public void addSegmentCount(int value) {
        this.docSegTotal += value;
    }
}

