/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiUnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BOMNewlineEncodingDetector {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final int MAX_LOOKAHEAD = 8192;
    public static final String UTF_16 = "UTF-16";
    public static final String UTF_16BE = "UTF-16BE";
    public static final String UTF_16LE = "UTF-16LE";
    public static final String UTF_8 = "UTF-8";
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String EBCDIC = "Cp037";
    public static final String SCSU = "SCSU";
    public static final String UTF_7 = "UTF-7";
    public static final String UTF_EBCDIC = "UTF-EBCDIC";
    public static final String BOCU_1 = "BOCU-1";
    public static final String UTF_32 = "UTF-32";
    public static final String UTF_32BE = "UTF-32BE";
    public static final String UTF_32LE = "UTF-32LE";
    private String defaultEncoding = "ISO-8859-1";
    private final InputStream inputStream;
    private String encoding = null;
    private String encodingSpecificationInfo = null;
    private boolean definitive = true;
    private int bomSize;
    private boolean hasUtf8Bom;
    private boolean hasUtf7Bom;
    private boolean hasBom;
    private boolean autodetected;
    private NewlineType newlineType = NewlineType.UNKOWN;

    public BOMNewlineEncodingDetector(InputStream inputStream) {
        this.inputStream = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream, 9216);
        inputStream.mark(8192);
        this.autodetected = false;
        this.bomSize = 0;
    }

    public BOMNewlineEncodingDetector(InputStream inputStream, String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
        this.inputStream = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream, 9216);
        inputStream.mark(8192);
        this.autodetected = false;
        this.bomSize = 0;
    }

    public BOMNewlineEncodingDetector(InputStream inputStream, Charset defaultEncoding) {
        this(inputStream, defaultEncoding.name());
    }

    public static NewlineType getNewlineType(CharSequence text) {
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\n') {
                return NewlineType.LF;
            }
            if (ch != '\r') continue;
            return ++i < text.length() && text.charAt(i) == '\n' ? NewlineType.CRLF : NewlineType.CR;
        }
        if (System.getProperty("line.separator").equals("\r\n")) {
            return NewlineType.CRLF;
        }
        if (System.getProperty("line.separator").equals("\n")) {
            return NewlineType.LF;
        }
        return NewlineType.CR;
    }

    private void setNewlineType() {
        int count = 0;
        Reader reader = null;
        try {
            int c;
            this.inputStream.mark(8192);
            reader = this.openReader();
            while ((c = reader.read()) != -1) {
                if ((count += 2) > 8192) {
                    this.LOGGER.debug("Could not find newlines within lookahead buffer. Setting default newline type.");
                    break;
                }
                if (c == 10) {
                    this.newlineType = NewlineType.LF;
                    return;
                }
                if (c != 13) continue;
                int c2 = reader.read();
                if (c2 == -1) {
                    this.newlineType = NewlineType.CR;
                    return;
                }
                this.newlineType = (char)c2 == '\n' ? NewlineType.CRLF : NewlineType.CR;
                return;
            }
        }
        catch (IOException e) {
            throw new OkapiUnsupportedEncodingException("I/O Error getting newline type", e);
        }
        finally {
            try {
                this.inputStream.reset();
            }
            catch (IOException e) {
                throw new OkapiIOException("Could not reset the input stream to it's start position", e);
            }
        }
        if (System.getProperty("line.separator").equals("\r\n")) {
            this.newlineType = NewlineType.CRLF;
            return;
        }
        if (System.getProperty("line.separator").equals("\n")) {
            this.newlineType = NewlineType.LF;
            return;
        }
        this.newlineType = NewlineType.CR;
    }

    public NewlineType getNewlineType() {
        if (this.newlineType == NewlineType.UNKOWN) {
            this.setNewlineType();
        }
        return this.newlineType;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getEncodingSpecificationInfo() {
        return this.encodingSpecificationInfo;
    }

    public boolean isDefinitive() {
        return this.definitive;
    }

    private Reader openReader() throws UnsupportedEncodingException {
        if (this.encoding == null) {
            return new InputStreamReader(this.inputStream, StandardCharsets.ISO_8859_1);
        }
        if (!Charset.isSupported(this.encoding)) {
            throw new UnsupportedEncodingException(this.encoding + " - " + this.encodingSpecificationInfo);
        }
        return new InputStreamReader(this.inputStream, this.encoding);
    }

    private boolean setEncoding(String encoding, String encodingSpecificationInfo) {
        this.encoding = encoding;
        this.encodingSpecificationInfo = encodingSpecificationInfo;
        return true;
    }

    public void detectBom() {
        try {
            this.detectBomInternal();
            try {
                this.setNewlineType();
            }
            catch (OkapiUnsupportedEncodingException okapiUnsupportedEncodingException) {}
        }
        catch (IOException e) {
            throw new OkapiIOException("Error detecting Byte Order Mark (BOM)", e);
        }
    }

    public void detectAndRemoveBom() {
        try {
            this.detectBomInternal();
            try {
                this.setNewlineType();
            }
            catch (OkapiUnsupportedEncodingException okapiUnsupportedEncodingException) {
                // empty catch block
            }
            if (this.hasBom()) {
                long skipped = this.inputStream.skip(this.getBomSize());
                this.inputStream.mark(8192);
                if (skipped != (long)this.getBomSize()) {
                    throw new IOException("The number of bytes skipped is not equal to the expected BOM size");
                }
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error detecting Byte Order Mark (BOM)", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean detectBomInternal() throws IOException {
        this.hasUtf8Bom = false;
        this.hasUtf7Bom = false;
        this.hasBom = false;
        try {
            this.inputStream.mark(8192);
            int b1 = this.inputStream.read();
            if (b1 == -1) {
                boolean bl = this.setEncoding(this.defaultEncoding, "empty input stream");
                return bl;
            }
            int b2 = this.inputStream.read();
            int b3 = this.inputStream.read();
            int b4 = this.inputStream.read();
            if (b1 == 239) {
                if (b2 == 187 && b3 == 191) {
                    this.hasUtf8Bom = true;
                    this.hasBom = true;
                    this.autodetected = true;
                    this.bomSize = 3;
                    boolean bl = this.setEncoding(UTF_8, "UTF-8 Byte Order Mark (EF BB BF)");
                    return bl;
                }
            } else if (b1 == 254) {
                if (b2 == 255) {
                    this.hasBom = true;
                    this.autodetected = true;
                    this.bomSize = 2;
                    boolean bl = this.setEncoding(UTF_16BE, "UTF-16 big-endian Byte Order Mark (FE FF)");
                    return bl;
                }
            } else if (b1 == 255) {
                if (b2 == 254) {
                    if (b3 == 0 && b4 == 0) {
                        this.hasBom = true;
                        this.autodetected = true;
                        this.bomSize = 4;
                        boolean bl = this.setEncoding(UTF_32LE, "UTF-32 little-endian Byte Order Mark (FF EE 00 00)");
                        return bl;
                    }
                    this.hasBom = true;
                    this.autodetected = true;
                    this.bomSize = 2;
                    boolean bl = this.setEncoding(UTF_16LE, "UTF-16 little-endian Byte Order Mark (FF EE)");
                    return bl;
                }
            } else if (b1 == 0) {
                if (b2 == 0 && b3 == 254 && b4 == 255) {
                    this.hasBom = true;
                    this.autodetected = true;
                    this.bomSize = 4;
                    boolean bl = this.setEncoding(UTF_32BE, "UTF-32 big-endian Byte Order Mark (00 00 FE FF)");
                    return bl;
                }
            } else if (b1 == 14) {
                if (b2 == 254 && b3 == 255) {
                    this.hasBom = true;
                    this.autodetected = true;
                    this.bomSize = 3;
                    boolean bl = this.setEncoding(SCSU, "SCSU Byte Order Mark (0E FE FF)");
                    return bl;
                }
            } else if (b1 == 43) {
                if (b2 == 47 && b3 == 118) {
                    this.hasUtf7Bom = true;
                    this.hasBom = true;
                    this.autodetected = true;
                    this.bomSize = 3;
                    boolean bl = this.setEncoding(UTF_7, "UTF-7 Byte Order Mark (2B 2F 76)");
                    return bl;
                }
            } else if (b1 == 221) {
                if (b2 == 115 && b3 == 102 && b4 == 115) {
                    this.hasBom = true;
                    this.autodetected = true;
                    this.bomSize = 4;
                    boolean bl = this.setEncoding(UTF_EBCDIC, "UTF-EBCDIC Byte Order Mark (DD 73 66 73)");
                    return bl;
                }
            } else if (b1 == 251 && b2 == 238 && b3 == 40) {
                this.hasBom = true;
                this.autodetected = true;
                this.bomSize = 3;
                boolean bl = this.setEncoding(BOCU_1, "BOCU-1 Byte Order Mark (FB EE 28)");
                return bl;
            }
            this.definitive = false;
            this.autodetected = false;
            this.hasBom = false;
            this.bomSize = 0;
            this.LOGGER.debug("BOM not found. Now trying to guess document encoding.");
            if (b4 == -1) {
                if (b2 == -1 || b3 != -1) {
                    boolean bl = this.setEncoding(ISO_8859_1, "default 8-bit ASCII-compatible encoding (stream 3 bytes long)");
                    return bl;
                }
                if (b1 == 0) {
                    boolean bl = this.setEncoding(UTF_16BE, "default 16-bit BE encoding (byte stream starts with 00, stream 2 bytes long)");
                    return bl;
                }
                if (b2 == 0) {
                    boolean bl = this.setEncoding(UTF_16LE, "default 16-bit LE encoding (byte stream pattern XX 00, stream 2 bytes long)");
                    return bl;
                }
                boolean bl = this.setEncoding(this.defaultEncoding, "default encoding: " + this.defaultEncoding);
                return bl;
            }
            if (b1 == 0) {
                if (b2 == 0) {
                    boolean bl = this.setEncoding(UTF_32BE, "default 32-bit BE encoding (byte stream starts with 00 00)");
                    return bl;
                }
                boolean bl = this.setEncoding(UTF_16BE, "default 16-bit BE encoding (byte stream starts with 00)");
                return bl;
            }
            if (b4 == 0) {
                if (b3 == 0) {
                    boolean bl = this.setEncoding(UTF_32LE, "default 32-bit LE encoding (byte stream starts with pattern XX ?? 00 00)");
                    return bl;
                }
                boolean bl = this.setEncoding(UTF_16LE, "default 16-bit LE encoding (byte stream stars with pattern XX ?? XX 00)");
                return bl;
            }
            if (b2 == 0) {
                boolean bl = this.setEncoding(UTF_16LE, "default 16-bit LE encoding (byte stream starts with pattern XX 00 ?? XX)");
                return bl;
            }
            if (b3 == 0) {
                boolean bl = this.setEncoding(UTF_16BE, "default 16-bit BE encoding (byte stream starts with pattern XX XX 00 XX)");
                return bl;
            }
            if (b1 == 76) {
                if (b2 == 111 && b3 == 167 && b4 == 148) {
                    boolean bl = this.setEncoding(EBCDIC, "default EBCDIC encoding (<?xml...> detected)");
                    return bl;
                }
                if (b2 == 90 && b3 == 196 && b4 == 214) {
                    boolean bl = this.setEncoding(EBCDIC, "default EBCDIC encoding (<!DOCTYPE...> detected)");
                    return bl;
                }
                if (b2 == 136 && b3 == 163 && b4 == 148) {
                    boolean bl = this.setEncoding(EBCDIC, "default EBCDIC-compatible encoding (HTML element detected)");
                    return bl;
                }
                if (b2 == 200 && b3 == 227 && b4 == 212) {
                    boolean bl = this.setEncoding(EBCDIC, "default EBCDIC-compatible encoding (HTML element detected)");
                    return bl;
                }
            }
            boolean bl = this.setEncoding(this.defaultEncoding, "default encoding: " + this.defaultEncoding);
            return bl;
        }
        finally {
            this.inputStream.reset();
        }
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public boolean hasBom() {
        return this.hasBom;
    }

    public boolean hasUtf8Bom() {
        return this.hasUtf8Bom;
    }

    public boolean hasUtf7Bom() {
        return this.hasUtf7Bom;
    }

    public boolean isAutodetected() {
        return this.autodetected;
    }

    public int getBomSize() {
        return this.bomSize;
    }

    public boolean hasUtf8Encoding() {
        return this.getEncoding().equals(UTF_8);
    }

    public static enum NewlineType {
        CR("\r"),
        LF("\n"),
        CRLF("\r\n"),
        UNKOWN("");

        private final String stringValue;

        private NewlineType(String stringValue) {
            this.stringValue = stringValue;
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

