/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListUtil {
    public static List<String> stringAsList(String st) {
        return ListUtil.listTrimValues(ListUtil.stringAsList(st, ","));
    }

    public static List<LocaleId> stringAsLanguageList(String input) {
        if (input == null) {
            return null;
        }
        ArrayList<LocaleId> res = new ArrayList<LocaleId>();
        ArrayList<String> list = new ArrayList<String>();
        ListUtil.stringAsList(list, input, ",");
        for (String lang : list) {
            if (Util.isEmpty(lang = lang.trim())) continue;
            res.add(LocaleId.fromString(lang));
        }
        return res;
    }

    public static void stringAsList(List<String> list, String st) {
        ListUtil.stringAsList(list, st, ",");
        ListUtil.listTrimValues(list);
    }

    public static List<String> stringAsList(String st, String delimiter) {
        ArrayList<String> res = new ArrayList<String>();
        ListUtil.stringAsList(res, st, delimiter);
        return res;
    }

    public static List<String> stringAsList(String st, char delimiter) {
        ArrayList<String> res = new ArrayList<String>();
        ListUtil.stringAsList(res, st, Character.toString(delimiter));
        return res;
    }

    public static void stringAsList(List<String> list, String st, String delimiter) {
        int index;
        if (Util.isEmpty(st)) {
            return;
        }
        if (list == null) {
            return;
        }
        list.clear();
        if (Util.isEmpty(delimiter)) {
            list.add(st);
            return;
        }
        int start = 0;
        int len = delimiter.length();
        while ((index = st.substring(start).indexOf(delimiter)) != -1) {
            list.add(st.substring(start, start + index));
            start += index + len;
        }
        if (start <= st.length()) {
            list.add(st.substring(start));
        }
    }

    public static String[] stringAsArray(String st) {
        List<String> list = ListUtil.stringAsList(st);
        if (Util.isEmpty(list)) {
            return new String[0];
        }
        return list.toArray(new String[0]);
    }

    public static String[] stringAsArray(String st, String delimiter) {
        List<String> list = ListUtil.stringAsList(st, delimiter);
        if (Util.isEmpty(list)) {
            return new String[0];
        }
        return list.toArray(new String[0]);
    }

    public static String merge(String[] array, int start, int end, String joiner) {
        if (!Util.checkIndex(start, array) && !Util.checkIndex(end, array)) {
            return "";
        }
        if (start < 0 && Util.checkIndex(end, array)) {
            start = 0;
        }
        if (Util.checkIndex(start, array) && end >= array.length) {
            end = array.length - 1;
        }
        if (start >= end) {
            return "";
        }
        StringBuilder tmp = new StringBuilder(array[start]);
        for (int i = start + 1; i < end + 1; ++i) {
            tmp.append(joiner);
            tmp.append(array[i]);
        }
        return tmp.toString();
    }

    public static String merge(List<String> list, int start, int end, String joiner) {
        return ListUtil.merge(ListUtil.stringListAsArray(list), start, end, joiner);
    }

    public static List<Integer> stringAsIntList(String st) {
        return ListUtil.stringAsIntList(st, ",");
    }

    public static List<Integer> stringAsIntList(String st, String delimiter) {
        return ListUtil.stringAsIntList(st, delimiter, false);
    }

    public static List<Integer> stringAsIntList(String st, String delimiter, boolean sortList) {
        String[] parts;
        ArrayList<Integer> res = new ArrayList<Integer>();
        if (Util.isEmpty(st)) {
            return res;
        }
        for (String part : parts = st.split(delimiter)) {
            if (Util.isEmpty(part.trim())) {
                res.add(0);
                continue;
            }
            res.add(Integer.valueOf(part.trim()));
        }
        if (sortList) {
            Collections.sort(res);
        }
        return res;
    }

    public static void listTrimTrail(List<String> list) {
        if (list == null) {
            return;
        }
        for (int i = list.size() - 1; i >= 0 && Util.isEmpty(list.get(i)); --i) {
            list.remove(i);
        }
    }

    public static List<String> listTrimValues(List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String st : list) {
            if (Util.isEmpty(st)) {
                res.add(st);
                continue;
            }
            res.add(st.trim());
        }
        return res;
    }

    public static String[] stringListAsArray(List<String> list) {
        if (Util.isEmpty(list)) {
            return new String[0];
        }
        return list.toArray(new String[0]);
    }

    public static Class<?>[] classListAsArray(List<Class<?>> list) {
        if (Util.isEmpty(list)) {
            return null;
        }
        Class[] res = (Class[])Array.newInstance(Class.class, list.size());
        for (int i = 0; i < list.size(); ++i) {
            res[i] = list.get(i);
        }
        return res;
    }

    public static Object[] objectListAsArray(List<Object> list) {
        if (Util.isEmpty(list)) {
            return null;
        }
        return list.toArray();
    }

    public static <E> List<E> arrayAsList(E[] array) {
        return new ArrayList<E>(Arrays.asList(array));
    }

    public static String arrayAsString(String[] array) {
        return ListUtil.arrayAsString(array, ",");
    }

    public static String arrayAsString(String[] array, String delimiter) {
        return ListUtil.listAsString(Arrays.asList(array), delimiter);
    }

    public static String listAsString(List<String> list) {
        return ListUtil.listAsString(list, ",");
    }

    public static String listAsString(List<String> list, String delimiter) {
        if (list == null) {
            return "";
        }
        String res = "";
        for (int i = 0; i < list.size(); ++i) {
            res = i > 0 ? res + delimiter + list.get(i) : list.get(i);
        }
        return res;
    }

    public static String intListAsString(List<Integer> list) {
        return ListUtil.intListAsString(list, ",");
    }

    public static String intListAsString(List<Integer> list, String delimiter) {
        ArrayList<String> stList = new ArrayList<String>();
        for (Integer value : list) {
            stList.add(Util.intToStr(value));
        }
        return ListUtil.listAsString(stList, delimiter);
    }

    public static <E> List<E> invert(List<E> list) {
        if (list == null) {
            return null;
        }
        ArrayList<E> res = new ArrayList<E>(list);
        Collections.reverse(res);
        return res;
    }

    public static <E> void remove(List<E> list, int start, int end) {
        if (list == null) {
            return;
        }
        if (Util.isEmpty(list)) {
            return;
        }
        for (int i = start; i < end; ++i) {
            list.remove(start);
        }
    }

    public static <E> List<E> copyItems(List<E> list, int start, int end) {
        List res;
        if (list == null) {
            return null;
        }
        Logger localLogger = LoggerFactory.getLogger(ListUtil.class);
        try {
            res = (List)list.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            localLogger.debug("List instantiation failed in ListUtil.copyItems(): {}", (Object)e.getMessage());
            return null;
        }
        if (Util.checkIndex(start, list) && Util.checkIndex(end, list)) {
            res.addAll(list.subList(start, end + 1));
        }
        return res;
    }

    public static <E> List<E> moveItems(List<E> buffer, int start, int end) {
        List<E> res = ListUtil.copyItems(buffer, start, end);
        if (res == null) {
            return null;
        }
        buffer.subList(start, end + 1).clear();
        return res;
    }

    public static <E> List<E> moveItems(List<E> buffer) {
        List<E> res = ListUtil.copyItems(buffer, 0, buffer.size() - 1);
        if (res == null) {
            return null;
        }
        buffer.clear();
        return res;
    }

    public static <E> E getFirstNonNullItem(List<E> list) {
        if (Util.isEmpty(list)) {
            return null;
        }
        for (E item : list) {
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public static List<String> loadList(Class<?> classRef, String resourceLocation) {
        ArrayList<String> res = new ArrayList<String>();
        ListUtil.loadList(res, classRef, resourceLocation);
        return res;
    }

    public static void loadList(List<String> list, Class<?> classRef, String resourceLocation) {
        if (list == null) {
            return;
        }
        if (classRef == null) {
            return;
        }
        if (Util.isEmpty(resourceLocation)) {
            return;
        }
        Logger localLogger = LoggerFactory.getLogger(ListUtil.class);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(classRef.getResourceAsStream(resourceLocation), StandardCharsets.UTF_8));){
            list.clear();
            while (reader.ready()) {
                String line = reader.readLine();
                if (line == null) {
                    break;
                }
                if (Util.isEmpty(line) || line.startsWith("#")) continue;
                list.add(line);
            }
        }
        catch (IOException e) {
            localLogger.debug("ListUtil.loadList() IO problem of \"{}\": {}", (Object)resourceLocation, (Object)e.getMessage());
            return;
        }
    }
}

