/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import com.ibm.icu.util.IllformedLocaleException;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.Util;

public final class LocaleId
implements Comparable<Object> {
    private final ULocale uLocale;
    public static final LocaleId EMPTY = LocaleId.fromString("");
    private static final String LOCALE_ID_ALL = "*all*";
    private static final ULocale ICU_ALL = new ULocale("*all*");
    public static final LocaleId ALL = new LocaleId(ICU_ALL);
    public static final LocaleId AUTODETECT = EMPTY;
    public static final LocaleId ARABIC = LocaleId.fromString("ar");
    public static final LocaleId CHINA_CHINESE = LocaleId.fromString("zh-cn");
    public static final LocaleId TAIWAN_CHINESE = LocaleId.fromString("zh-tw");
    public static final LocaleId ENGLISH = LocaleId.fromString("en");
    public static final LocaleId US_ENGLISH = LocaleId.fromString("en-US");
    public static final LocaleId FRENCH = LocaleId.fromString("fr");
    public static final LocaleId GERMAN = LocaleId.fromString("de");
    public static final LocaleId HEBREW = LocaleId.fromString("he");
    public static final LocaleId ITALIAN = LocaleId.fromString("it");
    public static final LocaleId JAPANESE = LocaleId.fromString("ja");
    public static final LocaleId KOREAN = LocaleId.fromString("ko-kr");
    public static final LocaleId PORTUGUESE = LocaleId.fromString("pt");
    public static final LocaleId RUSSIAN = LocaleId.fromString("ru");
    public static final LocaleId SPANISH = LocaleId.fromString("es");
    private static final Pattern BIDILOCALES = Pattern.compile("(ar|arc|arz|bcc|bqi|ckb|dv|fa|glk|he|iw|ku|mzn|pnb|ps|sd|ug|ur|yi|syr|syc)(-.*)?", 2);
    private String originalLocId;
    private static final int POSIX_LANGUAGE = 1;
    private static final int POSIX_REGION = 3;
    private static final int POSIX_VARIANT = 7;
    private static final Pattern POSIX_PATTERN = Pattern.compile("\\A(\\p{Alpha}{2,3})(_(\\p{Alpha}*?))?(\\.([\\p{Alnum}_-]*?))?(@([\\p{Alnum}_-]*?))?\\z");

    public static String replaceVariables(String input, LocaleId srcLoc, LocaleId trgLoc) {
        ULocale uLoc;
        if (!input.contains("${")) {
            return input;
        }
        String result = input;
        result = result.replace("${Src", "${src");
        result = result.replace("${Trg", "${trg");
        if (srcLoc == null) {
            srcLoc = EMPTY;
        }
        if (trgLoc == null) {
            trgLoc = EMPTY;
        }
        String srcTmp = srcLoc.toIcuLocale().getBaseName().replace('_', '-');
        result = result.replace("${srcLangU}", srcTmp.toUpperCase(Locale.US));
        result = result.replace("${srcLangL}", srcTmp.toLowerCase(Locale.US));
        result = result.replace("${srcLang}", srcTmp);
        String trgTmp = trgLoc.toIcuLocale().getBaseName().replace('_', '-');
        result = result.replace("${trgLangU}", trgTmp.toUpperCase(Locale.US));
        result = result.replace("${trgLangL}", trgTmp.toLowerCase(Locale.US));
        if ((result = result.replace("${trgLang}", trgTmp)).contains("${srcLoc")) {
            uLoc = srcLoc.toIcuLocale();
            result = result.replace("${srcLoc}", uLoc.getBaseName());
            result = result.replace("${srcLocLang}", uLoc.getLanguage());
            result = result.replace("${srcLocScript}", uLoc.getScript());
            result = result.replace("${srcLocVariant}", uLoc.getVariant());
            result = result.replace("${srcLocReg}", uLoc.getCountry());
        }
        if (result.contains("${trgLoc")) {
            uLoc = trgLoc.toIcuLocale();
            result = result.replace("${trgLoc}", uLoc.getBaseName());
            result = result.replace("${trgLocLang}", uLoc.getLanguage());
            result = result.replace("${trgLocScript}", uLoc.getScript());
            result = result.replace("${trgLocVariant}", uLoc.getVariant());
            result = result.replace("${trgLocReg}", uLoc.getCountry());
        }
        return result;
    }

    public static String replaceVariables(String input, String srcLoc, String trgLoc) {
        return LocaleId.replaceVariables(input, LocaleId.fromString(srcLoc == null ? "" : srcLoc), LocaleId.fromString(trgLoc == null ? "" : trgLoc));
    }

    private static ULocale okapiLocaleToULocale(String locId) {
        if (locId == null) {
            throw new IllegalArgumentException("The locale identifier cannot be null.");
        }
        switch (locId.toLowerCase(Locale.US)) {
            case "": {
                return ULocale.ROOT;
            }
            case "*all*": {
                return ICU_ALL;
            }
            case "ja-jp-x-calja": {
                return new ULocale("ja-JP-u-ca-japanese");
            }
            case "th-th-x-numth": {
                return new ULocale("th-TH-u-nu-thai");
            }
        }
        return new ULocale(locId);
    }

    private static String okapiLocaleFromULocale(ULocale locale) {
        String langTag;
        if (locale == null) {
            throw new IllegalArgumentException("The locale cannot be null.");
        }
        if (locale == ULocale.ROOT) {
            return "";
        }
        if (locale == ICU_ALL) {
            return LOCALE_ID_ALL;
        }
        switch (langTag = locale.toLanguageTag()) {
            case "ja-JP-u-ca-japanese": {
                return "ja-jp-x-calja";
            }
            case "th-TH-u-nu-thai": {
                return "th-th-x-numth";
            }
        }
        return langTag;
    }

    @Deprecated
    public LocaleId(String locId, boolean normalize) {
        this.originalLocId = locId;
        this.uLocale = LocaleId.okapiLocaleToULocale(locId);
    }

    public LocaleId(String language) {
        if (Util.isEmpty(language)) {
            throw new IllegalArgumentException("The language cannot be null or empty.");
        }
        if (!language.matches("^[a-zA-Z]{2,3}$")) {
            throw new IllegalArgumentException("The language should be a 2 or 3 character ISO code.");
        }
        this.uLocale = LocaleId.okapiLocaleToULocale(language);
    }

    public LocaleId(String language, String region) {
        if (Util.isEmpty(language)) {
            throw new IllegalArgumentException("The language cannot be null or empty.");
        }
        this.uLocale = new ULocale.Builder().setLanguage(language).setRegion(region).build();
    }

    public LocaleId(String language, String region, String userPart) {
        if (Util.isEmpty(language)) {
            throw new IllegalArgumentException("The language cannot be null or empty.");
        }
        this.uLocale = new ULocale.Builder().setLanguage(language).setRegion(region).setExtension('x', userPart).build();
    }

    public LocaleId(ULocale uLoc) {
        if (uLoc == null) {
            throw new IllegalArgumentException("The locale cannot be null.");
        }
        this.uLocale = (ULocale)uLoc.clone();
    }

    public LocaleId(Locale loc) {
        if (loc == null) {
            throw new IllegalArgumentException("The locale cannot be null.");
        }
        this.uLocale = ULocale.forLocale((Locale)loc);
    }

    public String toString() {
        return LocaleId.okapiLocaleFromULocale(this.uLocale);
    }

    @Deprecated
    public String getOriginalLocId() {
        return this.originalLocId;
    }

    public LocaleId clone() {
        return this;
    }

    public int hashCode() {
        return this.uLocale.hashCode();
    }

    @Deprecated
    public boolean equals(String arg) {
        return this.equals(LocaleId.fromString(arg));
    }

    @Override
    @Deprecated
    public int compareTo(String arg) {
        return this.compareTo(LocaleId.fromString(arg));
    }

    public boolean equalToString(String str) {
        return this.equals(LocaleId.fromString(str));
    }

    public boolean equals(Object arg) {
        return this.compareTo(arg) == 0;
    }

    @Override
    public int compareTo(Object arg) {
        if (arg == null) {
            return 1;
        }
        if (arg instanceof LocaleId) {
            String locId1 = this.toBCP47();
            String locId2 = ((LocaleId)arg).toBCP47();
            return locId1.compareTo(locId2);
        }
        if (arg instanceof String) {
            String locId1 = this.toBCP47();
            String locId2 = LocaleId.fromString((String)arg).toBCP47();
            return locId1.compareTo(locId2);
        }
        return 1;
    }

    public static LocaleId fromString(String locId) {
        LocaleId result = new LocaleId(LocaleId.okapiLocaleToULocale(locId));
        result.originalLocId = locId;
        return result;
    }

    public static LocaleId fromPOSIXLocale(String locId) {
        if (Util.isEmpty(locId)) {
            throw new IllegalArgumentException("The locale identifier cannot be null or empty.");
        }
        Matcher m = POSIX_PATTERN.matcher(locId);
        if (m.find()) {
            String variant;
            String region;
            ULocale.Builder builder = new ULocale.Builder();
            String lang = m.group(1);
            if (!Util.isEmpty(lang)) {
                builder.setLanguage(lang);
            }
            if (!Util.isEmpty(region = m.group(3))) {
                builder.setRegion(region);
            }
            if (!Util.isEmpty(variant = m.group(7))) {
                switch (variant.toLowerCase(Locale.US)) {
                    case "euro": {
                        builder.setUnicodeLocaleKeyword("cu", "EUR");
                        break;
                    }
                    case "ats": {
                        builder.setUnicodeLocaleKeyword("cu", "ATS");
                        break;
                    }
                    case "latin": {
                        builder.setScript("Latn");
                        break;
                    }
                    default: {
                        builder.setExtension('x', variant);
                    }
                }
            }
            LocaleId result = new LocaleId(builder.build());
            result.originalLocId = locId;
            return result;
        }
        throw new IllegalArgumentException(String.format("The POSIX locale '%s' is invalid.", locId));
    }

    public String toPOSIXLocaleId() {
        String tmp = this.getLanguage();
        if (this.getRegion() != null) {
            tmp = tmp + "_" + this.getRegion().toUpperCase();
        }
        return tmp;
    }

    public static LocaleId fromBCP47(String langtag, boolean strict) {
        ULocale ulocale;
        if (langtag == null) {
            throw new IllegalArgumentException("The language tag cannot be null.");
        }
        if (strict) {
            try {
                ulocale = new ULocale.Builder().setLanguageTag(langtag).build();
            }
            catch (IllformedLocaleException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        } else {
            if (langtag.isEmpty()) {
                return EMPTY;
            }
            ulocale = ULocale.forLanguageTag((String)langtag);
        }
        LocaleId result = new LocaleId(ulocale);
        result.originalLocId = langtag;
        return result;
    }

    public static LocaleId fromBCP47(String langtag) {
        return LocaleId.fromBCP47(langtag, false);
    }

    public String toBCP47() {
        if (this.uLocale == ICU_ALL) {
            return LOCALE_ID_ALL;
        }
        return this.uLocale.toLanguageTag();
    }

    public Locale toJavaLocale() {
        return this.uLocale.toLocale();
    }

    public ULocale toIcuLocale() {
        return this.uLocale;
    }

    public String getLanguage() {
        return this.uLocale.getLanguage();
    }

    public String getRegion() {
        String result = this.uLocale.getCountry();
        return result.isEmpty() ? null : result;
    }

    public String getScript() {
        String result = this.uLocale.getScript();
        return result.isEmpty() ? null : result;
    }

    public String getVariant() {
        String result = this.uLocale.getVariant();
        return result.isEmpty() ? null : result;
    }

    public String getUserPart() {
        String langTag;
        switch (langTag = this.uLocale.toLanguageTag()) {
            case "ja-JP-u-ca-japanese": {
                return "calja";
            }
            case "th-TH-u-nu-thai": {
                return "numth";
            }
        }
        return this.uLocale.getExtension('x');
    }

    public boolean sameLanguageAs(LocaleId other) {
        if (other == null) {
            return false;
        }
        return this.getLanguage().equals(other.getLanguage());
    }

    public boolean sameLanguageAs(String langCode) {
        return this.getLanguage().equals(ULocale.getLanguage((String)langCode));
    }

    public boolean sameRegionAs(LocaleId other) {
        if (other == null) {
            return false;
        }
        return this.uLocale.getCountry().equals(other.uLocale.getCountry());
    }

    public boolean sameRegionAs(String locId) {
        return this.uLocale.getCountry().equals(ULocale.getCountry((String)locId));
    }

    public boolean sameUserPartAs(LocaleId other) {
        if (other == null) {
            return false;
        }
        String userPart1 = this.getUserPart();
        String userPart2 = other.getUserPart();
        if (userPart1 == null && userPart2 == null) {
            return true;
        }
        if (userPart1 == null) {
            return false;
        }
        return userPart1.equals(userPart2);
    }

    public boolean sameUserPartAs(String langCode) {
        return this.sameUserPartAs(LocaleId.fromString(langCode));
    }

    public static LocaleId[] getAvailableLocales() {
        ULocale[] jlocales = ULocale.getAvailableLocales();
        LocaleId[] locIds = new LocaleId[jlocales.length];
        for (int i = 0; i < jlocales.length; ++i) {
            locIds[i] = LocaleId.fromString(jlocales[i].toLanguageTag());
        }
        return locIds;
    }

    @Deprecated
    public static String[] splitLanguageCode(String locId) {
        String[] parts = new String[]{"", ""};
        if (locId == null || locId.length() == 0) {
            return parts;
        }
        LocaleId loc = LocaleId.fromString(locId);
        String language = loc.getLanguage();
        String region = loc.getRegion();
        if (language != null) {
            parts[0] = language;
        }
        if (region != null) {
            parts[1] = region;
        }
        return parts;
    }

    public static boolean isBidirectional(LocaleId locId) {
        if (locId.uLocale.isRightToLeft()) {
            return true;
        }
        return BIDILOCALES.matcher(locId.toBCP47()).matches();
    }

    public static boolean hasCharactersAsNumeralSeparators(LocaleId localeId) {
        return HEBREW.getLanguage().equals(localeId.getLanguage());
    }

    public static List<LocaleId> convertToLocaleIds(List<String> languageCodes) {
        ArrayList<LocaleId> locales = new ArrayList<LocaleId>();
        for (String languageCode : languageCodes) {
            locales.add(LocaleId.fromString(languageCode));
        }
        return locales;
    }
}

