/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import net.sf.okapi.common.annotation.IAnnotation;

public class InlineAnnotation
implements IAnnotation {
    public static final String CLASSNAME_SEPARATOR = "\u009a";
    protected String data;

    public static InlineAnnotation createFromString(String storage) {
        InlineAnnotation annotation;
        if (storage == null) {
            return new InlineAnnotation();
        }
        if (storage.startsWith(CLASSNAME_SEPARATOR)) {
            int p = storage.indexOf(CLASSNAME_SEPARATOR, CLASSNAME_SEPARATOR.length());
            String className = storage.substring(CLASSNAME_SEPARATOR.length(), p);
            try {
                Object obj = Class.forName(className).newInstance();
                annotation = (InlineAnnotation)obj;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e.getMessage());
            }
        } else {
            annotation = new InlineAnnotation();
        }
        annotation.fromString(storage);
        return annotation;
    }

    public InlineAnnotation() {
    }

    public InlineAnnotation(String data) {
        this.data = data;
    }

    public InlineAnnotation clone() {
        return new InlineAnnotation(this.data);
    }

    @Override
    public String toString() {
        return this.data;
    }

    public void fromString(String storage) {
        this.data = storage;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }
}

