/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.bifile;

import java.nio.charset.Charset;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String BIFILE = "biFile";
    private static final String INPUTENCODING = "inputEncoding";

    public String getBiFile() {
        return this.getString(BIFILE);
    }

    public void setBiFile(String biFile) {
        this.setString(BIFILE, biFile);
    }

    public String getInputEncoding() {
        return this.getString(INPUTENCODING);
    }

    public void setInputEncoding(String inputEncoding) {
        this.setString(INPUTENCODING, inputEncoding);
    }

    @Override
    public void reset() {
        super.reset();
        this.setBiFile("");
        this.setInputEncoding(Charset.defaultCharset().name());
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(BIFILE, "Bilingual file", "The bilingual file from which to leverage");
        desc.add(INPUTENCODING, "Input encoding", "The encoding of the bilingual file");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Bilingual File Connector Settings", true, false);
        desc.addPathInputPart(paramsDesc.get(BIFILE), "Bilingual file", false);
        desc.addTextInputPart(paramsDesc.get(INPUTENCODING));
        return desc;
    }
}

