/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.globalsight;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String SERVERURL = "serverURL";
    private static final String TMPROFILE = "tmProfile";

    public Parameters() {
    }

    public Parameters(String initialData) {
        super(initialData);
    }

    public String getUsername() {
        return this.getString(USERNAME);
    }

    public void setUsername(String username) {
        this.setString(USERNAME, username);
    }

    public String getPassword() {
        return this.getString(PASSWORD);
    }

    public void setPassword(String password) {
        this.setString(PASSWORD, password);
    }

    public String getServerURL() {
        return this.getString(SERVERURL);
    }

    public void setServerURL(String serverURL) {
        this.setString(SERVERURL, serverURL);
    }

    public String getTmProfile() {
        return this.getString(TMPROFILE);
    }

    public void setTmProfile(String tmProfile) {
        this.setString(TMPROFILE, tmProfile);
    }

    @Override
    public void reset() {
        super.reset();
        this.setUsername("");
        this.setPassword("");
        this.setServerURL("http://HOST:PORT/globalsight/services/AmbassadorWebService?wsdl");
        this.setTmProfile("default");
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(SERVERURL, "Server URL", "The full URL of the TM server (e.g. http://xyz:8080/globalsight/services/AmbassadorWebService?wsdl");
        desc.add(USERNAME, "User name", "The login name to use");
        desc.add(PASSWORD, "Password", "The password for the given user name");
        desc.add(TMPROFILE, "TM profile", "The name of the TM profile to use");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("GlobalSight TM Connector Settings");
        desc.addTextInputPart(paramsDesc.get(SERVERURL));
        desc.addTextInputPart(paramsDesc.get(USERNAME));
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(PASSWORD));
        tip.setPassword(true);
        desc.addTextInputPart(paramsDesc.get(TMPROFILE));
        return desc;
    }
}

