/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.icml;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.SpinInputPart;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider,
ISimplifierRulesParameters {
    private static final String EXTRACTNOTES = "extractNotes";
    private static final String SIMPLIFYCODES = "simplifyCodes";
    private static final String EXTRACTMASTERSPREADS = "extractMasterSpreads";
    private static final String SKIPTHRESHOLD = "skipThreshold";
    private static final String NEWTUONBR = "newTuOnBr";
    private boolean extractNotes;
    private boolean simplifyCodes;
    private boolean extractMasterSpreads;
    private int skipThreshold;
    private boolean newTuOnBr;

    public Parameters() {
        this.reset();
        this.toString();
    }

    @Override
    public void reset() {
        this.extractNotes = false;
        this.simplifyCodes = true;
        this.extractMasterSpreads = true;
        this.skipThreshold = 1000;
        this.newTuOnBr = false;
        this.setSimplifierRules(null);
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.extractNotes = this.buffer.getBoolean(EXTRACTNOTES, this.extractNotes);
        this.simplifyCodes = this.buffer.getBoolean(SIMPLIFYCODES, this.simplifyCodes);
        this.extractMasterSpreads = this.buffer.getBoolean(EXTRACTMASTERSPREADS, this.extractMasterSpreads);
        this.skipThreshold = this.buffer.getInteger(SKIPTHRESHOLD, this.skipThreshold);
        this.newTuOnBr = this.buffer.getBoolean(NEWTUONBR, this.newTuOnBr);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(EXTRACTNOTES, this.extractNotes);
        this.buffer.setBoolean(SIMPLIFYCODES, this.simplifyCodes);
        this.buffer.setBoolean(EXTRACTMASTERSPREADS, this.extractMasterSpreads);
        this.buffer.setInteger(SKIPTHRESHOLD, this.skipThreshold);
        this.buffer.setBoolean(NEWTUONBR, this.newTuOnBr);
        return this.buffer.toString();
    }

    public boolean getExtractNotes() {
        return this.extractNotes;
    }

    public void setExtractNotes(boolean extractNotes) {
        this.extractNotes = extractNotes;
    }

    public boolean getSimplifyCodes() {
        return this.simplifyCodes;
    }

    public void setSimplifyCodes(boolean simplifyCodes) {
        this.simplifyCodes = simplifyCodes;
    }

    public boolean getExtractMasterSpreads() {
        return this.extractMasterSpreads;
    }

    public void setExtractMasterSpreads(boolean extractMasterSpreads) {
        this.extractMasterSpreads = extractMasterSpreads;
    }

    public int getSkipThreshold() {
        return this.skipThreshold;
    }

    public void setSkipThreshold(int skipThreshold) {
        this.skipThreshold = skipThreshold;
    }

    public boolean getNewTuOnBr() {
        return this.newTuOnBr;
    }

    public void setNewTuOnBr(boolean newTuOnBr) {
        this.newTuOnBr = newTuOnBr;
    }

    @Override
    public String getSimplifierRules() {
        return this.getString("simplifierRules");
    }

    @Override
    public void setSimplifierRules(String rules) {
        this.setString("simplifierRules", rules);
    }

    @Override
    public void validateSimplifierRules() throws ParseException {
        SimplifierRules r = new SimplifierRules(this.getSimplifierRules(), new Code());
        r.parse();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(EXTRACTNOTES, "Extract notes", null);
        desc.add(EXTRACTMASTERSPREADS, "Extract master spreads", null);
        desc.add(SIMPLIFYCODES, "Simplify inline codes when possible", null);
        desc.add(NEWTUONBR, "Create new paragraphs on hard returns (<Br/> elements) [BETA]", null);
        desc.add(SKIPTHRESHOLD, "Maximum spread size", "Skip any spread larger than the given value (in Kbytes)");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("ICML Filter", true, false);
        desc.addCheckboxPart(paramsDesc.get(EXTRACTNOTES));
        desc.addCheckboxPart(paramsDesc.get(EXTRACTMASTERSPREADS));
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramsDesc.get(SIMPLIFYCODES));
        desc.addSeparatorPart();
        SpinInputPart sip = desc.addSpinInputPart(paramsDesc.get(SKIPTHRESHOLD));
        sip.setRange(1, 32000);
        return desc;
    }
}

