/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.idml.Element;
import net.sf.okapi.filters.idml.PathPoint;

class GeometryPath
implements Element {
    private final StartElement startElement;
    private final StartElement pathPointArrayStartElement;
    private final List<PathPoint> pathPoints;
    private final EndElement pathPointArrayEndElement;
    private final EndElement endElement;

    GeometryPath(StartElement startElement, StartElement pathPointArrayStartElement, List<PathPoint> pathPoints, EndElement pathPointArrayEndElement, EndElement endElement) {
        this.startElement = startElement;
        this.pathPointArrayStartElement = pathPointArrayStartElement;
        this.pathPoints = pathPoints;
        this.pathPointArrayEndElement = pathPointArrayEndElement;
        this.endElement = endElement;
    }

    @Override
    public StartElement startElement() {
        return this.startElement;
    }

    @Override
    public List<XMLEvent> innerEvents() {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        events.add(this.pathPointArrayStartElement);
        this.pathPoints.forEach(p -> events.addAll(p.getEvents()));
        events.add(this.pathPointArrayEndElement);
        return events;
    }

    @Override
    public void updateInnerEventsWith(List<XMLEvent> events) {
    }

    List<PathPoint> pathPoints() {
        return this.pathPoints;
    }

    @Override
    public EndElement endElement() {
        return this.endElement;
    }

    @Override
    public void apply(FontMappings fontMappings) {
    }

    @Override
    public List<XMLEvent> getEvents() {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        events.add(this.startElement);
        events.addAll(this.innerEvents());
        events.add(this.endElement);
        return events;
    }

    @Override
    public QName getName() {
        return this.startElement.getName();
    }

    static class Builder
    implements net.sf.okapi.filters.idml.Builder<GeometryPath> {
        private StartElement startElement;
        private StartElement pathPointArrayStartElement;
        private List<PathPoint> pathPoints = new ArrayList<PathPoint>();
        private EndElement pathPointArrayEndElement;
        private EndElement endElement;

        Builder() {
        }

        Builder setStartElement(StartElement startElement) {
            this.startElement = startElement;
            return this;
        }

        Builder setPathPointArrayStartElement(StartElement pathPointArrayStartElement) {
            this.pathPointArrayStartElement = pathPointArrayStartElement;
            return this;
        }

        Builder addPathPoint(PathPoint pathPoint) {
            this.pathPoints.add(pathPoint);
            return this;
        }

        Builder setPathPointArrayEndElement(EndElement pathPointArrayEndElement) {
            this.pathPointArrayEndElement = pathPointArrayEndElement;
            return this;
        }

        Builder setEndElement(EndElement endElement) {
            this.endElement = endElement;
            return this;
        }

        @Override
        public GeometryPath build() {
            return new GeometryPath(this.startElement, this.pathPointArrayStartElement, this.pathPoints, this.pathPointArrayEndElement, this.endElement);
        }
    }
}

