/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.Deque;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import net.sf.okapi.filters.idml.OrderingIdioms;

interface Point {
    public double x();

    public double y();

    public Point transformedWith(Deque<OrderingIdioms.TransformationMatrix> var1);

    public String toString();

    public static final class Comparator
    implements java.util.Comparator<Point> {
        private final OrderingIdioms.Direction direction;

        Comparator(OrderingIdioms.Direction direction) {
            this.direction = direction;
        }

        @Override
        public int compare(Point point, Point anotherPoint) {
            if (OrderingIdioms.Direction.RIGHT_TO_LEFT == this.direction) {
                int result = Double.compare(anotherPoint.x(), point.x());
                if (0 != result) {
                    return result;
                }
                return Double.compare(anotherPoint.y(), point.y());
            }
            int result = Double.compare(point.x(), anotherPoint.x());
            if (0 != result) {
                return result;
            }
            return Double.compare(point.y(), anotherPoint.y());
        }
    }

    public static final class Default
    implements Point {
        private final double x;
        private final double y;

        Default(StartElement startElement, QName attributeName) {
            this(startElement.getAttributeByName(attributeName));
        }

        Default(Attribute attribute) {
            this(attribute.getValue().split(" "));
        }

        Default(String[] coordinates) {
            this(coordinates[0], coordinates[1]);
        }

        Default(String x, String y) {
            this(Double.parseDouble(x), Double.parseDouble(y));
        }

        Default(double x, double y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public double x() {
            return this.x;
        }

        @Override
        public double y() {
            return this.y;
        }

        @Override
        public Point transformedWith(Deque<OrderingIdioms.TransformationMatrix> transformationMatrices) {
            Iterator<OrderingIdioms.TransformationMatrix> transformationMatrixIterator = transformationMatrices.descendingIterator();
            Default p = this;
            while (transformationMatrixIterator.hasNext()) {
                OrderingIdioms.TransformationMatrix tm = transformationMatrixIterator.next();
                p = new Default(tm.getA() * p.x() + tm.getC() * p.y() + tm.getTx(), tm.getB() * p.x() + tm.getD() * p.y() + tm.getTy());
            }
            return p;
        }

        @Override
        public String toString() {
            return String.valueOf(this.x).concat(" ").concat(String.valueOf(this.y));
        }
    }
}

