/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.Namespaces;
import net.sf.okapi.filters.idml.ParsingIdioms;
import net.sf.okapi.filters.idml.Properties;
import net.sf.okapi.filters.idml.Property;
import net.sf.okapi.filters.idml.PropertyParser;
import net.sf.okapi.filters.idml.SpreadItem;
import net.sf.okapi.filters.idml.State;
import net.sf.okapi.filters.idml.StateParser;
import net.sf.okapi.filters.idml.TextPath;

class SpreadItemParser {
    private static final QName PATH_GEOMETRY = Namespaces.getDefaultNamespace().getQName("PathGeometry");
    private static final QName PARENT_STORY = Namespaces.getDefaultNamespace().getQName("ParentStory");
    private static final QName PREVIOUS_TEXT_FRAME = Namespaces.getDefaultNamespace().getQName("PreviousTextFrame");
    private static final QName NEXT_TEXT_FRAME = Namespaces.getDefaultNamespace().getQName("NextTextFrame");
    private static final QName TEXT_PATH = Namespaces.getDefaultNamespace().getQName("TextPath");
    private static final QName STATE = Namespaces.getDefaultNamespace().getQName("State");
    protected final StartElement startElement;
    protected final String activeLayerId;
    protected final XMLEventReader eventReader;
    protected final XMLEventFactory eventFactory;

    SpreadItemParser(StartElement startElement, String activeLayerId, XMLEventReader eventReader, XMLEventFactory eventFactory) {
        this.startElement = startElement;
        this.activeLayerId = activeLayerId;
        this.eventReader = eventReader;
        this.eventFactory = eventFactory;
    }

    void parseStartElement(SpreadItem.SpreadItemBuilder spreadItemBuilder) {
        spreadItemBuilder.setId(this.startElement.getAttributeByName(ParsingIdioms.SELF).getValue());
        spreadItemBuilder.setLayerId(ParsingIdioms.getItemLayerAttributeValue(this.startElement, this.activeLayerId));
        spreadItemBuilder.setVisible(ParsingIdioms.getBooleanAttributeValue(this.startElement, ParsingIdioms.VISIBLE, true));
        spreadItemBuilder.setTransformation(this.startElement.getAttributeByName(ParsingIdioms.ITEM_TRANSFORM).getValue());
    }

    void parseProperties(SpreadItem.SpreadItemBuilder spreadItemBuilder) throws XMLStreamException {
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (event.isEndElement() && Properties.NAME.equals(event.asEndElement().getName())) {
                return;
            }
            if (!event.isStartElement()) continue;
            if (!PATH_GEOMETRY.equals(event.asStartElement().getName())) {
                spreadItemBuilder.addProperty(new PropertyParser(event.asStartElement(), this.eventReader, this.eventFactory).parse());
                continue;
            }
            spreadItemBuilder.addProperty(this.parsePathGeometryProperty(event.asStartElement(), this.eventReader, this.eventFactory));
        }
        throw new IllegalStateException("Unexpected structure");
    }

    private Property.PathGeometryProperty parsePathGeometryProperty(StartElement startElement, XMLEventReader eventReader, XMLEventFactory eventFactory) throws XMLStreamException {
        return new PropertyParser.PathGeometryPropertyParserRange(startElement, eventReader, eventFactory).parse();
    }

    SpreadItem parse(SpreadItem.SpreadItemBuilder spreadItemBuilder) throws XMLStreamException {
        this.parseStartElement(spreadItemBuilder);
        return (SpreadItem)spreadItemBuilder.build();
    }

    static class TextBoxParser
    extends SpreadItemParser {
        TextBoxParser(StartElement startElement, String activeLayerId, XMLEventReader eventReader, XMLEventFactory eventFactory) {
            super(startElement, activeLayerId, eventReader, eventFactory);
        }

        SpreadItem.TextBox parse(SpreadItem.TextBox.TextBoxBuilder textBoxBuilder) throws XMLStreamException {
            super.parseStartElement(textBoxBuilder);
            ParsingIdioms.parseSpreadItems(this.startElement, this.eventReader, this.eventFactory, textBoxBuilder);
            return (SpreadItem.TextBox)super.parse(textBoxBuilder);
        }
    }

    static class GroupParser
    extends SpreadItemParser {
        GroupParser(StartElement startElement, String activeLayerId, XMLEventReader eventReader, XMLEventFactory eventFactory) {
            super(startElement, activeLayerId, eventReader, eventFactory);
        }

        SpreadItem.Group parse(SpreadItem.Group.GroupBuilder groupBuilder) throws XMLStreamException {
            super.parseStartElement(groupBuilder);
            ParsingIdioms.parseSpreadItems(this.startElement, this.eventReader, this.eventFactory, groupBuilder);
            return (SpreadItem.Group)super.parse(groupBuilder);
        }
    }

    static class ButtonParser
    extends MultiStateObjectParser {
        ButtonParser(StartElement startElement, String activeLayerId, XMLEventReader eventReader, XMLEventFactory eventFactory) {
            super(startElement, activeLayerId, eventReader, eventFactory);
        }

        SpreadItem.Button parse(SpreadItem.Button.ButtonBuilder buttonBuilder) throws XMLStreamException {
            return (SpreadItem.Button)super.parse(buttonBuilder);
        }
    }

    static class MultiStateObjectParser
    extends SpreadItemParser {
        MultiStateObjectParser(StartElement startElement, String activeLayerId, XMLEventReader eventReader, XMLEventFactory eventFactory) {
            super(startElement, activeLayerId, eventReader, eventFactory);
        }

        SpreadItem.MultiStateObject parse(SpreadItem.MultiStateObject.MultiStateObjectBuilder multiStateObjectBuilder) throws XMLStreamException {
            super.parseStartElement(multiStateObjectBuilder);
            while (this.eventReader.hasNext()) {
                XMLEvent event = this.eventReader.nextEvent();
                if (event.isEndElement() && event.asEndElement().getName().equals(this.startElement.getName())) {
                    return multiStateObjectBuilder.build();
                }
                if (!event.isStartElement() || !event.asStartElement().getName().equals(STATE)) continue;
                multiStateObjectBuilder.addState(this.parseState(event.asStartElement(), this.activeLayerId, this.eventReader));
            }
            throw new IllegalStateException("Unexpected structure");
        }

        private State parseState(StartElement startElement, String activeLayerId, XMLEventReader eventReader) throws XMLStreamException {
            return new StateParser(startElement, activeLayerId, eventReader, this.eventFactory).parse();
        }
    }

    static class PolygonParser
    extends TextualSpreadItemParser {
        PolygonParser(StartElement startElement, String activeLayerId, XMLEventReader eventReader, XMLEventFactory eventFactory) {
            super(startElement, activeLayerId, eventReader, eventFactory);
        }

        SpreadItem.Polygon parse(SpreadItem.Polygon.PolygonBuilder polygonBuilder) throws XMLStreamException {
            return (SpreadItem.Polygon)super.parse(polygonBuilder);
        }
    }

    static class OvalParser
    extends TextualSpreadItemParser {
        OvalParser(StartElement startElement, String activeLayerId, XMLEventReader eventReader, XMLEventFactory eventFactory) {
            super(startElement, activeLayerId, eventReader, eventFactory);
        }

        SpreadItem.Oval parse(SpreadItem.Oval.OvalBuilder ovalBuilder) throws XMLStreamException {
            return (SpreadItem.Oval)super.parse(ovalBuilder);
        }
    }

    static class RectangleParser
    extends TextualSpreadItemParser {
        RectangleParser(StartElement startElement, String activeLayerId, XMLEventReader eventReader, XMLEventFactory eventFactory) {
            super(startElement, activeLayerId, eventReader, eventFactory);
        }

        SpreadItem.Rectangle parse(SpreadItem.Rectangle.RectangleBuilder rectangleBuilder) throws XMLStreamException {
            return (SpreadItem.Rectangle)super.parse(rectangleBuilder);
        }
    }

    static class GraphicLineParser
    extends TextualSpreadItemParser {
        GraphicLineParser(StartElement startElement, String activeLayerId, XMLEventReader eventReader, XMLEventFactory eventFactory) {
            super(startElement, activeLayerId, eventReader, eventFactory);
        }

        SpreadItem.GraphicLine parse(SpreadItem.GraphicLine.GraphicLineBuilder graphicLineBuilder) throws XMLStreamException {
            return (SpreadItem.GraphicLine)super.parse(graphicLineBuilder);
        }
    }

    static class TextFrameParser
    extends TextualSpreadItemParser {
        TextFrameParser(StartElement startElement, String activeLayerId, XMLEventReader eventReader, XMLEventFactory eventFactory) {
            super(startElement, activeLayerId, eventReader, eventFactory);
        }

        SpreadItem.TextFrame parse(SpreadItem.TextFrame.TextFrameBuilder textFrameBuilder) throws XMLStreamException {
            textFrameBuilder.setStoryId(this.startElement.getAttributeByName(PARENT_STORY).getValue());
            textFrameBuilder.setPreviousTextFrameId(this.startElement.getAttributeByName(PREVIOUS_TEXT_FRAME).getValue());
            textFrameBuilder.setNextTextFrameId(this.startElement.getAttributeByName(NEXT_TEXT_FRAME).getValue());
            return (SpreadItem.TextFrame)super.parse(textFrameBuilder);
        }
    }

    static class TextualSpreadItemParser
    extends SpreadItemParser {
        TextualSpreadItemParser(StartElement startElement, String activeLayerId, XMLEventReader eventReader, XMLEventFactory eventFactory) {
            super(startElement, activeLayerId, eventReader, eventFactory);
        }

        SpreadItem.TextualSpreadItem parse(SpreadItem.TextualSpreadItem.TextualSpreadItemBuilder textualSpreadItemBuilder) throws XMLStreamException {
            super.parseStartElement(textualSpreadItemBuilder);
            while (this.eventReader.hasNext()) {
                XMLEvent event = this.eventReader.nextEvent();
                if (event.isEndElement() && event.asEndElement().getName().equals(this.startElement.getName())) {
                    return textualSpreadItemBuilder.build();
                }
                if (!event.isStartElement()) continue;
                if (Properties.NAME.equals(event.asStartElement().getName())) {
                    super.parseProperties(textualSpreadItemBuilder);
                    continue;
                }
                if (!TEXT_PATH.equals(event.asStartElement().getName())) continue;
                textualSpreadItemBuilder.addTextPath(this.parseTextPath(event.asStartElement()));
            }
            throw new IllegalStateException("Unexpected structure");
        }

        private TextPath parseTextPath(StartElement startElement) {
            TextPath.TextPathBuilder textPathBuilder = new TextPath.TextPathBuilder();
            textPathBuilder.setStoryId(startElement.getAttributeByName(PARENT_STORY).getValue());
            textPathBuilder.setPreviousTextFrameId(startElement.getAttributeByName(PREVIOUS_TEXT_FRAME).getValue());
            textPathBuilder.setNextTextFrameId(startElement.getAttributeByName(NEXT_TEXT_FRAME).getValue());
            return textPathBuilder.build();
        }
    }
}

