/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.idml.Markup;
import net.sf.okapi.filters.idml.MarkupRange;
import net.sf.okapi.filters.idml.StyleDefinitionsReader;
import net.sf.okapi.filters.idml.ZipInput;

interface StyleDefinitions
extends Markup {
    public void from(ZipEntry var1) throws IOException, XMLStreamException;

    public static class Default
    implements StyleDefinitions {
        private final Markup.Default defaultMarkup;
        private final ZipInput<XMLEventReader> zipInputReader;
        private final XMLEventFactory eventFactory;

        Default(Markup.Default defaultMarkup, ZipInput<XMLEventReader> zipInputReader, XMLEventFactory eventFactory) {
            this.defaultMarkup = defaultMarkup;
            this.zipInputReader = zipInputReader;
            this.eventFactory = eventFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void from(ZipEntry entry) throws IOException, XMLStreamException {
            XMLEventReader eventReader = null;
            try {
                eventReader = this.zipInputReader.of(entry);
                StyleDefinitionsReader.Cached reader = new StyleDefinitionsReader.Cached(new StyleDefinitionsReader.Default(eventReader, this.eventFactory));
                this.defaultMarkup.add(new MarkupRange.Start(reader.startDocument()));
                this.defaultMarkup.add(new MarkupRange.Start(reader.startElement()));
                this.defaultMarkup.add(reader.rootCharacterStyleGroup());
                this.defaultMarkup.add(reader.rootParagraphStyleGroup());
                reader.tablesOfContents().forEach(r -> this.defaultMarkup.add((MarkupRange)r));
                this.defaultMarkup.add(reader.rootCellStyleGroup());
                this.defaultMarkup.add(reader.rootTableStyleGroup());
                this.defaultMarkup.add(reader.rootObjectStyleGroup());
                reader.trapPresets().forEach(r -> this.defaultMarkup.add((MarkupRange)r));
                this.defaultMarkup.add(new MarkupRange.End(reader.endElement()));
                this.defaultMarkup.add(new MarkupRange.End(reader.endDocument()));
            }
            finally {
                if (null != eventReader) {
                    eventReader.close();
                }
            }
        }

        @Override
        public void add(MarkupRange markupRange) {
            this.defaultMarkup.add(markupRange);
        }

        @Override
        public Iterator<MarkupRange> iterator() {
            return this.defaultMarkup.iterator();
        }

        @Override
        public void apply(FontMappings fontMappings) {
            this.defaultMarkup.apply(fontMappings);
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.defaultMarkup.getEvents();
        }
    }
}

