/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.multiparsers;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filters.SubFilter;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.multiparsers.CsvParser;
import net.sf.okapi.filters.multiparsers.IParser;
import net.sf.okapi.filters.multiparsers.Parameters;
import net.sf.okapi.filters.multiparsers.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiParsersFilter
implements IFilter {
    public static final int MODE_CSV = 0;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Pattern patFix1 = Pattern.compile("__(.*?)__( *)\r\n(?!(\r\n))");
    private final Pattern patFix2 = Pattern.compile("\\*\\*(.*?)\\*\\*( *)\r\n(?!(\r\n))");
    private final Pattern patFix3 = Pattern.compile("\\]\\((.*?)\\)( *)\r\n(?!(\r\n))");
    private final Pattern patTarget = Pattern.compile("\\{:target=(.*?)\\}", 2);
    private int mode = 0;
    private String currentMimeType = "application/x-multiparsers";
    private EncoderManager encoderManager = null;
    private IFilterConfigurationMapper fcMapper;
    private String docId;
    private Parameters params = new Parameters();
    private LocaleId srcLoc;
    private IParser parser = null;
    private int tuId;
    private int dpId;
    private boolean cancelled;
    private LinkedList<Event> events;
    private boolean done;
    private boolean hasNextWasCalled;
    private int sectionIndex;

    @Override
    public String getName() {
        return "okf_multiparsers";
    }

    @Override
    public String getDisplayName() {
        return "Multi-Parsers Filter";
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        Path path = Paths.get(input.getInputURI());
        if (input.getInputURI() == null) {
            throw new OkapiIOException("No inputURI specified.");
        }
        this.srcLoc = input.getSourceLocale();
        this.parser = new CsvParser(path.toFile().getAbsolutePath(), this.params, this.fcMapper);
        this.tuId = 0;
        this.dpId = 0;
        this.cancelled = false;
        this.done = false;
        this.hasNextWasCalled = false;
        this.events = new LinkedList();
        this.docId = UUID.randomUUID().toString();
        StartDocument sd = new StartDocument(this.docId);
        sd.setFilterId(this.getName());
        sd.setFilterParameters(this.params);
        sd.setFilterWriter(this.createFilterWriter());
        sd.setEncoding("UTF-8", false);
        sd.setLineBreak("\r\n");
        if (this.mode == 0) {
            this.currentMimeType = "text/csv";
        }
        sd.setMimeType(this.currentMimeType);
        if (input.getInputURI() != null) {
            sd.setName(input.getInputURI().getPath());
        }
        sd.setLocale(this.srcLoc);
        this.events.add(new Event(EventType.START_DOCUMENT, sd));
    }

    @Override
    public void close() {
        if (this.parser != null) {
            this.parser.close();
            this.parser = null;
        }
    }

    @Override
    public boolean hasNext() {
        this.hasNextWasCalled = true;
        if (this.parser == null) {
            return false;
        }
        if (this.events.isEmpty()) {
            boolean more = this.parser.hasNext();
            if (more) {
                return true;
            }
            if (!this.done) {
                this.buildEndDocument();
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public Event next() {
        if (this.cancelled) {
            this.close();
            return new Event(EventType.CANCELED);
        }
        if (!this.hasNextWasCalled && !this.hasNext()) {
            this.buildEndDocument();
        }
        this.hasNextWasCalled = false;
        if (this.events.isEmpty()) {
            Token token = (Token)this.parser.next();
            do {
                if (token.isText()) {
                    if (token.getFilterConfigId() == null) {
                        TextUnit tu = new TextUnit(this.nextTuId(), token.getData());
                        this.events.add(new Event(EventType.TEXT_UNIT, tu));
                    } else {
                        IFilter sf = this.parser.getSubFilter(token.getFilterConfigId());
                        if (sf == null) {
                            throw new OkapiIOException("Unexpected filter: " + token.getFilterConfigId());
                        }
                        this.processWithSubfilter(token, sf);
                    }
                } else {
                    DocumentPart dp = new DocumentPart(this.nextDpId(), false, new GenericSkeleton(token.getData()));
                    this.events.add(new Event(EventType.DOCUMENT_PART, dp));
                }
                if (!this.events.isEmpty()) continue;
                if (this.parser.hasNext()) {
                    token = (Token)this.parser.next();
                    continue;
                }
                this.buildEndDocument();
            } while (this.events.isEmpty());
        }
        Event event = this.events.poll();
        return event;
    }

    private void buildEndDocument() {
        Ending ed = new Ending(this.docId);
        this.events.add(new Event(EventType.END_DOCUMENT, ed));
        this.done = true;
    }

    protected String preProcessDataForMarkdown(String data) {
        Matcher m1 = this.patFix1.matcher(data);
        data = m1.replaceAll("__$1__$2\r\n\r\n[mrk1]");
        Matcher m2 = this.patFix2.matcher(data);
        data = m2.replaceAll("**$1**$2\r\n\r\n[mrk1]");
        Matcher m3 = this.patFix3.matcher(data);
        data = m3.replaceAll("]($1)$2\r\n\r\n[mrk1]");
        return data;
    }

    public String autoDetectColumnTypes(String csvPath, int autoDetectRowNum) {
        String matchedLine = null;
        try (BufferedReader br = new BufferedReader(new FileReader(csvPath));){
            String currentLine;
            int lineCount = 1;
            while ((currentLine = br.readLine()) != null) {
                if (autoDetectRowNum == lineCount) {
                    matchedLine = currentLine;
                    break;
                }
                ++lineCount;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (matchedLine == null) {
            throw new RuntimeException("Could not find a matching line at row number " + autoDetectRowNum);
        }
        return matchedLine;
    }

    private void processWithSubfilter(Token token, IFilter filterToUse) {
        String dataToUse = token.getData();
        if (filterToUse.getName().startsWith("okf_markdown")) {
            dataToUse = this.preProcessDataForMarkdown(dataToUse);
        }
        this.logger.info("sf: {}", (Object)dataToUse);
        ITextUnit tu = new TextUnit(this.nextTuId(), dataToUse);
        SubFilter subfilter = new SubFilter(filterToUse, this.encoderManager.getEncoder(), ++this.sectionIndex, tu.getId(), null);
        subfilter.open(new RawDocument(dataToUse, this.srcLoc));
        while (subfilter.hasNext()) {
            Event e = subfilter.next();
            if (e.isTextUnit() && (tu = e.getTextUnit()).isTranslatable()) {
                String tmp = tu.getSource().getCodedText();
                Matcher m = this.patTarget.matcher(tmp);
                while (m.find()) {
                    int sta = m.start(0);
                    int end = m.end(0);
                    TextFragment tf = tu.getSource().getFirstContent();
                    tf.changeToCode(sta, end, TextFragment.TagType.PLACEHOLDER, "target");
                    tmp = tf.getCodedText();
                    m = this.patTarget.matcher(tmp);
                }
            }
            this.events.add(e);
        }
        subfilter.close();
        this.events.add(subfilter.createRefEvent(tu));
    }

    private String nextTuId() {
        ++this.tuId;
        return "tu" + this.tuId;
    }

    private String nextDpId() {
        ++this.dpId;
        return "dp" + this.dpId;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("text/csv", "net.sf.okapi.filters.multiparsers.CsvEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public String getMimeType() {
        return this.currentMimeType;
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration("okf_multiparsers", "text/csv", this.getClass().getName(), "Multi-Parsers: CSV with Plain-Text", "Configuration for CSV files with plain-text on all columns", null, ".csv;"));
        return list;
    }
}

