/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import net.sf.okapi.filters.openxml.BlockPropertiesClarifier;
import net.sf.okapi.filters.openxml.ClarificationParameters;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.CreationalParameters;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentClarifier;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesClarifier;
import net.sf.okapi.filters.openxml.StyleType;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class BidirectionalityClarifier {
    private static final int MAX_NUMBER_OF_CLARIFIABLE_WORD_STYLE_TYPES = 3;
    private final ConditionalParameters conditionalParameters;
    private final CreationalParameters creationalParameters;
    private final ClarificationParameters clarificationParameters;
    private final Set<String> clarifiableWordStyleTypes;

    BidirectionalityClarifier(ConditionalParameters conditionalParameters, CreationalParameters creationalParameters, ClarificationParameters clarificationParameters) {
        this.conditionalParameters = conditionalParameters;
        this.creationalParameters = creationalParameters;
        this.clarificationParameters = clarificationParameters;
        this.clarifiableWordStyleTypes = new HashSet<String>(3);
    }

    void clarifyMarkup(Markup markup) {
        ListIterator<MarkupComponent> iterator = markup.components().listIterator();
        while (iterator.hasNext()) {
            MarkupComponent component = iterator.next();
            if (MarkupComponent.isSheetViewStart(component)) {
                this.clarifySheetView(component);
                continue;
            }
            if (MarkupComponent.isAlignmentEmptyElement(component)) {
                this.clarifyAlignment(component);
                continue;
            }
            if (MarkupComponent.isPresentationStart(component)) {
                this.clarifyPresentation(component);
                continue;
            }
            if (MarkupComponent.isTableStart(component)) {
                this.clarifyTableProperties(iterator);
                continue;
            }
            if (MarkupComponent.isTextBodyStart(component)) {
                this.clarifyTextBodyProperties(iterator);
                continue;
            }
            if (MarkupComponent.isParagraphStart(component)) {
                this.clarifyParagraphProperties(iterator);
                continue;
            }
            if (!MarkupComponent.isWordStylesStart(component)) continue;
            this.clarifyWordStyles(iterator);
        }
    }

    private void clarifySheetView(MarkupComponent markupComponent) {
        new MarkupComponentClarifier.SheetViewClarifier(this.conditionalParameters, this.creationalParameters, this.clarificationParameters).clarify(markupComponent);
    }

    private void clarifyAlignment(MarkupComponent markupComponent) {
        new MarkupComponentClarifier.AlignmentClarifier(this.conditionalParameters, this.creationalParameters, this.clarificationParameters).clarify(markupComponent);
    }

    private void clarifyPresentation(MarkupComponent markupComponent) {
        new MarkupComponentClarifier.PresentationClarifier(this.conditionalParameters, this.creationalParameters, this.clarificationParameters).clarify(markupComponent);
    }

    private void clarifyTableProperties(ListIterator<MarkupComponent> markupComponentIterator) {
        new BlockPropertiesClarifier.TablePropertiesClarifier(this.conditionalParameters, this.creationalParameters, this.clarificationParameters).clarify(markupComponentIterator);
    }

    private void clarifyTextBodyProperties(ListIterator<MarkupComponent> markupComponentIterator) {
        new BlockPropertiesClarifier.TextBodyPropertiesClarifier(this.conditionalParameters, this.creationalParameters, this.clarificationParameters).clarify(markupComponentIterator);
    }

    private void clarifyParagraphProperties(ListIterator<MarkupComponent> markupComponentIterator) {
        new BlockPropertiesClarifier.ParagraphPropertiesClarifier(this.conditionalParameters, this.creationalParameters, this.clarificationParameters).clarify(markupComponentIterator);
    }

    private void clarifyWordStyles(ListIterator<MarkupComponent> iterator) {
        this.clarifiableWordStyleTypes.add(StyleType.TABLE.toString());
        this.clarifiableWordStyleTypes.add(StyleType.PARAGRAPH.toString());
        this.clarifiableWordStyleTypes.add(StyleType.CHARACTER.toString());
        while (iterator.hasNext()) {
            MarkupComponent component = iterator.next();
            if (MarkupComponent.isWordDocumentDefaultsStart(component)) {
                this.clarifyWordDocumentDefaults(iterator);
                continue;
            }
            if (MarkupComponent.isWordStyleStart(component)) {
                this.clarifyWordStyle((MarkupComponent.Start)component, iterator);
                continue;
            }
            if (!MarkupComponent.isWordStylesEnd(component)) continue;
            break;
        }
    }

    private void clarifyWordDocumentDefaults(ListIterator<MarkupComponent> iterator) {
        while (iterator.hasNext()) {
            MarkupComponent component = iterator.next();
            if (MarkupComponent.isWordParagraphPropertiesDefaultStart(component)) {
                this.clarifyParagraphProperties(iterator);
                this.clarifiableWordStyleTypes.remove(StyleType.PARAGRAPH.toString());
                continue;
            }
            if (MarkupComponent.isWordRunPropertiesDefaultStart(component)) {
                this.clarifyDefaultRunProperties(iterator);
                this.clarifiableWordStyleTypes.remove(StyleType.CHARACTER.toString());
                continue;
            }
            if (!MarkupComponent.isWordDocumentDefaultsEnd(component)) continue;
            break;
        }
    }

    private void clarifyDefaultRunProperties(ListIterator<MarkupComponent> iterator) {
        while (iterator.hasNext()) {
            MarkupComponent component = iterator.next();
            if (MarkupComponent.isRunProperties(component)) {
                iterator.set(this.clarifyRunProperties((RunProperties)component));
                continue;
            }
            if (!MarkupComponent.isWordRunPropertiesDefaultEnd(component)) continue;
            break;
        }
    }

    RunProperties clarifyRunProperties(RunProperties runProperties) {
        return new RunPropertiesClarifier(this.creationalParameters, this.clarificationParameters).clarify(runProperties);
    }

    private void clarifyWordStyle(MarkupComponent.Start startComponent, ListIterator<MarkupComponent> iterator) {
        if (!startComponent.containsAttributeWithAnyOfValues("type", this.clarifiableWordStyleTypes) || !startComponent.containsAttributeWithAnyOfValues("default", XMLEventHelpers.booleanAttributeTrueValues())) {
            return;
        }
        while (iterator.hasNext()) {
            MarkupComponent component = iterator.next();
            if (MarkupComponent.isParagraphBlockProperties(component)) {
                iterator.previous();
                this.clarifyParagraphProperties(iterator);
                continue;
            }
            if (MarkupComponent.isRunProperties(component)) {
                iterator.set(this.clarifyRunProperties((RunProperties)component));
                continue;
            }
            if (MarkupComponent.isTableBlockProperties(component)) {
                iterator.previous();
                this.clarifyTableProperties(iterator);
                continue;
            }
            if (!MarkupComponent.isWordStyleEnd(component)) continue;
            break;
        }
    }
}

