/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.List;
import java.util.ListIterator;
import javax.xml.stream.events.Attribute;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.ClarifiableAttribute;
import net.sf.okapi.filters.openxml.ClarificationParameters;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.CreationalParameters;
import net.sf.okapi.filters.openxml.MarkupComponent;

class MarkupComponentClarifierStrategy {
    protected ConditionalParameters conditionalParameters;
    protected CreationalParameters creationalParameters;
    protected ClarificationParameters clarificationParameters;
    protected ClarifiableAttribute clarifiableAttribute;

    MarkupComponentClarifierStrategy(ConditionalParameters conditionalParameters, CreationalParameters creationalParameters, ClarificationParameters clarificationParameters, ClarifiableAttribute clarifiableAttribute) {
        this.conditionalParameters = conditionalParameters;
        this.creationalParameters = creationalParameters;
        this.clarificationParameters = clarificationParameters;
        this.clarifiableAttribute = clarifiableAttribute;
    }

    void clarifyMarkupComponent(MarkupComponent markupComponent) {
        List<Attribute> attributes = this.getMarkupComponentAttributes(markupComponent);
        if (null == attributes) {
            return;
        }
        ListIterator<Attribute> attributeIterator = attributes.listIterator();
        while (attributeIterator.hasNext()) {
            Attribute attribute = attributeIterator.next();
            if (!this.clarifiableAttribute.getName().equals(attribute.getName().getLocalPart())) continue;
            if (!this.clarificationParameters.shouldBeBidirectional()) {
                attributeIterator.remove();
                return;
            }
            if (this.clarifiableAttribute.getValues().contains(attribute.getValue())) {
                return;
            }
            this.replaceAttribute(attributeIterator);
            return;
        }
        if (this.clarificationParameters.shouldBeBidirectional()) {
            attributeIterator.add(this.createRequiredAttribute());
        }
    }

    private List<Attribute> getMarkupComponentAttributes(MarkupComponent markupComponent) {
        if (markupComponent instanceof MarkupComponent.Start) {
            return ((MarkupComponent.Start)markupComponent).getAttributes();
        }
        if (markupComponent instanceof MarkupComponent.EmptyElement) {
            return ((MarkupComponent.EmptyElement)markupComponent).getAttributes();
        }
        if (markupComponent instanceof BlockProperties) {
            return ((BlockProperties)markupComponent).attributes();
        }
        return null;
    }

    private void replaceAttribute(ListIterator<Attribute> attributeIterator) {
        attributeIterator.remove();
        attributeIterator.add(this.createRequiredAttribute());
    }

    protected Attribute createRequiredAttribute() {
        return this.creationalParameters.getEventFactory().createAttribute(this.clarifiableAttribute.getPrefix(), this.creationalParameters.getNamespaceUri(), this.clarifiableAttribute.getName(), (String)this.clarifiableAttribute.getValues().stream().findFirst().orElseThrow(() -> new IllegalStateException()));
    }
}

