/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupZipSkeleton;
import net.sf.okapi.filters.openxml.NonTranslatablePart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MarkupModifiablePart
extends NonTranslatablePart {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final Document.General generalDocument;
    private final ZipEntry entry;
    private final Markup markup;

    MarkupModifiablePart(Document.General generalDocument, ZipEntry entry, Markup markup) {
        this.generalDocument = generalDocument;
        this.entry = entry;
        this.markup = markup;
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        DocumentPart dp = new DocumentPart(this.entry.getName(), false);
        MarkupZipSkeleton skel = new MarkupZipSkeleton(this.generalDocument.zipFile(), this.entry, this.generalDocument.outputFactory(), this.generalDocument.encoding(), this.markup);
        return new Event(EventType.DOCUMENT_PART, dp, skel);
    }

    @Override
    public void logEvent(Event e) {
        this.LOGGER.trace("[[ {}: {} ]]", (Object)this.getClass().getSimpleName(), (Object)this.entry.getName());
    }
}

