/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.filters.openxml.ContentFilter;
import net.sf.okapi.filters.openxml.DefaultPart;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.MasterPart;
import net.sf.okapi.filters.openxml.ModifiablePart;
import net.sf.okapi.filters.openxml.Namespace;
import net.sf.okapi.filters.openxml.Namespaces2;
import net.sf.okapi.filters.openxml.NonModifiablePart;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.Part;
import net.sf.okapi.filters.openxml.Presentation;
import net.sf.okapi.filters.openxml.PresentationNotesStyleDefinitions;
import net.sf.okapi.filters.openxml.PresentationSlide;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.RelationshipsPart;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.StyledTextPart;
import net.sf.okapi.filters.openxml.ZipEntryComparator;

class PowerpointDocument
implements Document {
    private static final String SLIDE_LAYOUT = "/slideLayout";
    private static final String COMMENTS = "/comments";
    private static final String NOTES_SLIDE = "/notesSlide";
    private static final String NOTES_MASTER = "/notesMaster";
    private static final String CHART = "/chart";
    private static final String DIAGRAM_DATA = "/diagramData";
    private static final Pattern RELS_NAME_PATTERN = Pattern.compile(".+slide\\d+\\.xml\\.rels");
    private Matcher relsNameMatcher = RELS_NAME_PATTERN.matcher("").reset();
    private final Document.General generalDocument;
    private Enumeration<? extends ZipEntry> entries;
    private StyleDefinitions presentationNotesStyleDefinitions;
    private List<String> slideNames = new ArrayList<String>();
    private List<String> slideLayoutNames = new ArrayList<String>();
    private Map<String, String> slidesByComment = new HashMap<String, String>();
    private Map<String, String> slidesByNote = new HashMap<String, String>();
    private Map<String, String> slidesByChart = new HashMap<String, String>();
    private Map<String, String> slidesByDiagramData = new HashMap<String, String>();

    PowerpointDocument(Document.General generalDocument) {
        this.generalDocument = generalDocument;
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        this.slideNames = this.findSlides();
        this.entries = this.entries();
        this.initialisePresentationNotesStyleDefinitions();
        this.slideLayoutNames = this.findSlideLayouts(this.slideNames);
        this.slidesByComment = this.findComments(this.slideNames);
        this.slidesByNote = this.findNotes(this.slideNames);
        this.slidesByChart = this.findCharts(this.slideNames);
        this.slidesByDiagramData = this.findDiagramDatas(this.slideNames);
        return this.generalDocument.startDocumentEvent();
    }

    private Enumeration<? extends ZipEntry> entries() throws IOException, XMLStreamException {
        Enumeration<? extends ZipEntry> entries = this.generalDocument.entries();
        ArrayList<? extends ZipEntry> entryList = Collections.list(entries);
        entryList.sort(new ZipEntryComparator(this.reorderedPartNames()));
        return Collections.enumeration(entryList);
    }

    private List<String> reorderedPartNames() throws IOException, XMLStreamException {
        LinkedList<String> names = new LinkedList<String>();
        for (String slideName : this.slideNames) {
            names.add(slideName);
            if (!this.generalDocument.conditionalParameters().getReorderPowerpointNotesAndComments()) continue;
            String namespaceUri = this.generalDocument.documentRelationshipsNamespace().uri();
            names.addAll(this.slideRelationshipTargetsForType(slideName, namespaceUri.concat(NOTES_SLIDE)));
            names.addAll(this.slideRelationshipTargetsForType(slideName, namespaceUri.concat(COMMENTS)));
        }
        return names;
    }

    private List<String> slideRelationshipTargetsForType(String slideName, String typeUri) throws IOException, XMLStreamException {
        List<Relationships.Rel> rels = this.generalDocument.relationshipsForPartName(slideName).getRelByType(typeUri);
        return rels == null ? Collections.emptyList() : rels.stream().map(r -> r.target).collect(Collectors.toList());
    }

    private void initialisePresentationNotesStyleDefinitions() throws IOException, XMLStreamException {
        String relationshipTarget = this.generalDocument.relationshipTargetFor(this.generalDocument.documentRelationshipsNamespace().uri().concat(NOTES_MASTER));
        if (null == relationshipTarget) {
            this.presentationNotesStyleDefinitions = new StyleDefinitions.Empty();
            return;
        }
        try (Reader reader = this.generalDocument.getPartReader(relationshipTarget);){
            this.presentationNotesStyleDefinitions = new PresentationNotesStyleDefinitions(this.generalDocument.conditionalParameters(), this.generalDocument.inputFactory(), this.generalDocument.eventFactory());
            this.presentationNotesStyleDefinitions.readWith(reader);
        }
    }

    List<String> findSlides() throws IOException, XMLStreamException {
        Relationships rels = this.generalDocument.getRelationships("ppt/_rels/presentation.xml.rels");
        Presentation pres = new Presentation(this.generalDocument.inputFactory(), rels);
        pres.parseFromXML(this.generalDocument.getPartReader("ppt/presentation.xml"));
        return pres.getSlidePartNames();
    }

    List<String> findSlideLayouts(List<String> slideNames) throws IOException, XMLStreamException {
        ArrayList<String> layouts = new ArrayList<String>();
        String typeUri = this.generalDocument.documentRelationshipsNamespace().uri().concat(SLIDE_LAYOUT);
        for (String slideName : slideNames) {
            List<Relationships.Rel> rels = this.generalDocument.relationshipsForPartName(slideName).getRelByType(typeUri);
            if (rels.isEmpty()) continue;
            layouts.add(rels.get((int)0).target);
        }
        return layouts;
    }

    private Map<String, String> findComments(List<String> slideNames) throws IOException, XMLStreamException {
        String namespaceUri = this.generalDocument.documentRelationshipsNamespace().uri();
        return this.generalDocument.RelsByEntry(slideNames, namespaceUri.concat(COMMENTS));
    }

    private Map<String, String> findNotes(List<String> slideNames) throws IOException, XMLStreamException {
        String namespaceUri = this.generalDocument.documentRelationshipsNamespace().uri();
        return this.generalDocument.RelsByEntry(slideNames, namespaceUri.concat(NOTES_SLIDE));
    }

    private Map<String, String> findCharts(List<String> slideNames) throws IOException, XMLStreamException {
        String namespaceUri = this.generalDocument.documentRelationshipsNamespace().uri();
        return this.generalDocument.RelsByEntry(slideNames, namespaceUri.concat(CHART));
    }

    private Map<String, String> findDiagramDatas(List<String> slideNames) throws IOException, XMLStreamException {
        String namespaceUri = this.generalDocument.documentRelationshipsNamespace().uri();
        return this.generalDocument.RelsByEntry(slideNames, namespaceUri.concat(DIAGRAM_DATA));
    }

    @Override
    public boolean isStyledTextPart(ZipEntry entry) {
        String type = this.generalDocument.contentTypeFor(entry);
        if (type.equals("application/vnd.openxmlformats-officedocument.presentationml.slide+xml")) {
            return true;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml")) {
            return true;
        }
        if (this.isMasterPart(entry.getName(), type)) {
            return true;
        }
        if (this.generalDocument.conditionalParameters().getTranslatePowerpointNotes() && type.equals("application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml")) {
            return true;
        }
        return type.equals("application/vnd.openxmlformats-officedocument.drawingml.chart+xml");
    }

    private boolean isMasterPart(String entryName, String type) {
        if (this.generalDocument.conditionalParameters().getTranslatePowerpointMasters()) {
            if (type.equals("application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml")) {
                return true;
            }
            if (type.equals("application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml") && this.slideLayoutNames.contains(entryName)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasPostponedTranslatables() {
        return false;
    }

    @Override
    public void updatePostponedTranslatables(String key, String value) {
    }

    @Override
    public boolean hasNextPart() {
        return this.entries.hasMoreElements();
    }

    @Override
    public Part nextPart() throws IOException, XMLStreamException {
        ParseType parseType;
        ZipEntry entry = this.entries.nextElement();
        String contentType = this.generalDocument.contentTypeFor(entry);
        this.relsNameMatcher.reset(entry.getName());
        if (PowerpointDocument.isRelationshipsPart(contentType) && this.relsNameMatcher.matches() && this.generalDocument.conditionalParameters().getExtractExternalHyperlinks()) {
            return new RelationshipsPart(this.generalDocument, entry);
        }
        if (!this.isTranslatablePart(entry)) {
            if (PowerpointDocument.isModifiablePart(contentType)) {
                return new ModifiablePart(this.generalDocument, entry, this.generalDocument.inputStreamFor(entry));
            }
            return new NonModifiablePart(this.generalDocument, entry);
        }
        StyleDefinitions styleDefinitions = "application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml".equals(contentType) ? this.presentationNotesStyleDefinitions : new StyleDefinitions.Empty();
        if (this.isStyledTextPart(entry)) {
            StyleOptimisation styleOptimisation = this.styleOptimisationsFor(entry, styleDefinitions);
            if (this.isMasterPart(entry.getName(), contentType)) {
                return new MasterPart(this.generalDocument, entry, styleDefinitions, styleOptimisation);
            }
            return new StyledTextPart(this.generalDocument, entry, styleDefinitions, styleOptimisation);
        }
        ContentFilter contentFilter = new ContentFilter(this.generalDocument.conditionalParameters(), entry.getName());
        this.generalDocument.conditionalParameters().nFileType = parseType = this.getParseType(contentType);
        contentFilter.setUpConfig(parseType);
        return new DefaultPart(this.generalDocument, entry, contentFilter);
    }

    private static boolean isRelationshipsPart(String contentType) {
        return "application/vnd.openxmlformats-package.relationships+xml".equals(contentType);
    }

    private static boolean isModifiablePart(String contentType) {
        return "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml".equals(contentType);
    }

    private StyleOptimisation styleOptimisationsFor(ZipEntry entry, StyleDefinitions styleDefinitions) throws IOException, XMLStreamException {
        Namespace namespace = this.namespacesOf(entry).forPrefix("a");
        if (null == namespace) {
            return new StyleOptimisation.Bypass();
        }
        return new StyleOptimisation.Default(new StyleOptimisation.Bypass(), this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), new QName(namespace.uri(), "pPr", namespace.prefix()), new QName(namespace.uri(), "defRPr", namespace.prefix()), Collections.emptyList(), styleDefinitions);
    }

    private Namespaces2 namespacesOf(ZipEntry entry) throws IOException, XMLStreamException {
        try (InputStreamReader reader = new InputStreamReader(this.generalDocument.inputStreamFor(entry));){
            Namespaces2.Default namespaces = new Namespaces2.Default(this.generalDocument.inputFactory());
            namespaces.readWith(reader);
            Namespaces2.Default default_ = namespaces;
            return default_;
        }
    }

    private ParseType getParseType(String contentType) {
        ParseType parseType;
        if (contentType.equals("application/vnd.openxmlformats-package.core-properties+xml")) {
            parseType = ParseType.MSWORDDOCPROPERTIES;
        } else if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.comments+xml")) {
            parseType = ParseType.MSPOWERPOINTCOMMENTS;
        } else {
            throw new IllegalStateException("Unexpected content type " + contentType);
        }
        return parseType;
    }

    private boolean isTranslatablePart(ZipEntry entry) throws IOException, XMLStreamException {
        String type = this.generalDocument.contentTypeFor(entry);
        if (!entry.getName().endsWith(".xml")) {
            return false;
        }
        if (this.isExcluded(entry.getName(), type)) {
            return false;
        }
        if (this.isHidden(entry.getName(), type)) {
            return false;
        }
        if (this.isStyledTextPart(entry)) {
            return true;
        }
        if (this.generalDocument.conditionalParameters().getTranslateDocProperties() && type.equals("application/vnd.openxmlformats-package.core-properties+xml")) {
            return true;
        }
        if (this.generalDocument.conditionalParameters().getTranslateComments() && type.equals("application/vnd.openxmlformats-officedocument.presentationml.comments+xml")) {
            return true;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml")) {
            return true;
        }
        return this.generalDocument.conditionalParameters().getTranslatePowerpointNotes() && type.equals("application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml");
    }

    private boolean isExcluded(String entryName, String contentType) {
        return this.isExcludedSlide(entryName, contentType) || this.isExcludedNote(entryName, contentType) || this.isExcludedComment(entryName, contentType) || this.isExcludedChart(entryName, contentType) || this.isExcludedDiagramData(entryName, contentType);
    }

    private boolean isExcludedSlide(String entryName, String contentType) {
        if (!"application/vnd.openxmlformats-officedocument.presentationml.slide+xml".equals(contentType)) {
            return false;
        }
        if (!this.generalDocument.conditionalParameters().getPowerpointIncludedSlideNumbersOnly()) {
            return false;
        }
        int slideIndex = this.slideNames.indexOf(entryName);
        if (slideIndex == -1) {
            return false;
        }
        int slideNumber = slideIndex + 1;
        return !this.generalDocument.conditionalParameters().tsPowerpointIncludedSlideNumbers.contains(slideNumber);
    }

    private boolean isExcludedNote(String entryName, String contentType) {
        if (!"application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml".equals(contentType) || !this.slidesByNote.containsKey(entryName)) {
            return false;
        }
        String slideName = this.slidesByNote.get(entryName);
        return this.isExcludedSlide(slideName, "application/vnd.openxmlformats-officedocument.presentationml.slide+xml");
    }

    private boolean isExcludedComment(String entryName, String contentType) {
        if (!"application/vnd.openxmlformats-officedocument.presentationml.comments+xml".equals(contentType) || !this.slidesByComment.containsKey(entryName)) {
            return false;
        }
        String slideName = this.slidesByComment.get(entryName);
        return this.isExcludedSlide(slideName, "application/vnd.openxmlformats-officedocument.presentationml.slide+xml");
    }

    private boolean isExcludedChart(String entryName, String contentType) {
        if (!"application/vnd.openxmlformats-officedocument.drawingml.chart+xml".equals(contentType) || !this.slidesByChart.containsKey(entryName)) {
            return false;
        }
        String slideName = this.slidesByChart.get(entryName);
        return this.isExcludedSlide(slideName, "application/vnd.openxmlformats-officedocument.presentationml.slide+xml");
    }

    private boolean isExcludedDiagramData(String entryName, String contentType) {
        if (!"application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml".equals(contentType) || !this.slidesByDiagramData.containsKey(entryName)) {
            return false;
        }
        String slideName = this.slidesByDiagramData.get(entryName);
        return this.isExcludedSlide(slideName, "application/vnd.openxmlformats-officedocument.presentationml.slide+xml");
    }

    private boolean isHidden(String entryName, String type) throws IOException, XMLStreamException {
        if (!this.generalDocument.conditionalParameters().getTranslatePowerpointHidden() && "application/vnd.openxmlformats-officedocument.presentationml.slide+xml".equals(type)) {
            return this.isHiddenSlide(entryName);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHiddenSlide(String entryName) throws IOException, XMLStreamException {
        XMLEventReader eventReader = null;
        try {
            eventReader = this.generalDocument.inputFactory().createXMLEventReader(this.generalDocument.getPartReader(entryName));
            boolean bl = PresentationSlide.fromXMLEventReader(eventReader).isHidden();
            return bl;
        }
        finally {
            if (null != eventReader) {
                eventReader.close();
            }
        }
    }

    @Override
    public void close() throws IOException {
    }
}

